/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.validation.validator;

import io.polaris.core.map.Maps;
import io.polaris.validation.InString;
import io.polaris.validation.Validations;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class InStringValidator
implements ConstraintValidator<InString, String> {
    private Set<String> values;

    public void initialize(InString constraintAnnotation) {
        this.values = new HashSet<String>();
        this.values.addAll(Arrays.asList(constraintAnnotation.value()));
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        if (this.values.contains(value)) {
            return true;
        }
        context.disableDefaultConstraintViolation();
        HashMap map = Maps.newHashMap();
        map.put("value", this.values.toString());
        String message = Validations.formatValidationMessage(context.getDefaultConstraintMessageTemplate(), map);
        context.buildConstraintViolationWithTemplate(message).addConstraintViolation();
        return false;
    }
}

