/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.channel.common.api;

import cn.foxtech.channel.common.api.ChannelServerAPI;
import cn.foxtech.channel.domain.ChannelRequestVO;
import cn.foxtech.channel.domain.ChannelRespondVO;
import cn.foxtech.core.exception.ServiceException;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ChannelClientAPI {
    @Autowired
    private ChannelServerAPI channelServerAPI;

    public ChannelRespondVO execute(ChannelRequestVO requestVO) throws ServiceException {
        ChannelRespondVO respondVO = this.channelServerAPI.execute(requestVO);
        return respondVO;
    }

    public void publish(ChannelRequestVO requestVO) throws ServiceException {
        this.channelServerAPI.publish(requestVO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ChannelRespondVO> reportTo(long timeout) throws ServiceException, InterruptedException {
        Object lock;
        Object object = lock = this.channelServerAPI.getReportLock();
        synchronized (object) {
            lock.wait(timeout);
        }
        List<ChannelRespondVO> list = this.channelServerAPI.report();
        return list;
    }

    public void openChannel(String channelName, Map<String, Object> channelParam) throws Exception {
        this.channelServerAPI.openChannel(channelName, channelParam);
    }

    public void closeChannel(String channelName, Map<String, Object> channelParam) {
        this.channelServerAPI.closeChannel(channelName, channelParam);
    }

    public ChannelRespondVO manageChannel(ChannelRequestVO requestVO) throws ServiceException {
        return this.channelServerAPI.manageChannel(requestVO);
    }
}

