/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.channel.common.scheduler;

import cn.foxtech.channel.common.api.ChannelClientAPI;
import cn.foxtech.channel.common.properties.ChannelProperties;
import cn.foxtech.channel.common.service.EntityManageService;
import cn.foxtech.channel.domain.ChannelBaseVO;
import cn.foxtech.channel.domain.ChannelRequestVO;
import cn.foxtech.channel.domain.ChannelRespondVO;
import cn.foxtech.common.entity.manager.RedisConsoleService;
import cn.foxtech.common.rpc.redis.channel.server.RedisListChannelServer;
import cn.foxtech.common.utils.scheduler.singletask.PeriodTaskService;
import cn.foxtech.core.exception.ServiceException;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RedisListRespondScheduler
extends PeriodTaskService {
    @Autowired
    private RedisConsoleService logger;
    @Autowired
    private EntityManageService entityManageService;
    @Autowired
    private RedisListChannelServer channelServer;
    @Autowired
    private ChannelClientAPI channelService;
    @Autowired
    private ChannelProperties constants;

    public void execute(long threadId) throws Exception {
        if (!this.entityManageService.isInitialized()) {
            Thread.sleep(1000L);
            return;
        }
        ChannelRequestVO requestVO = this.channelServer.popChannelRequest(1L, TimeUnit.SECONDS);
        if (requestVO == null) {
            return;
        }
        this.updateDeviceRespond(requestVO);
    }

    private void updateDeviceRespond(ChannelRequestVO requestVO) {
        try {
            if (ChannelRequestVO.MODE_EXCHANGE.equals(requestVO.getMode())) {
                ChannelRespondVO respondVO = this.execute(requestVO);
                respondVO.setUuid(requestVO.getUuid());
                respondVO.setType(this.constants.getChannelType());
                this.channelServer.pushChannelRespond(respondVO.getUuid(), respondVO);
            } else if (ChannelRequestVO.MODE_PUBLISH.equals(requestVO.getMode())) {
                ChannelRespondVO respondVO = this.publish(requestVO);
                respondVO.setUuid(requestVO.getUuid());
                respondVO.setType(this.constants.getChannelType());
                this.channelServer.pushChannelRespond(respondVO.getUuid(), respondVO);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
    }

    private ChannelRespondVO execute(ChannelRequestVO requestVO) {
        try {
            if (requestVO.getTimeout() > 60000) {
                throw new ServiceException("\u4e3a\u4e86\u907f\u514d\u8bbe\u5907\u6ca1\u54cd\u5e94\u65f6\u9020\u6210\u5835\u585e\uff0c\u4e0d\u5141\u8bb8\u6700\u5927\u8d85\u65f6\u5927\u4e8e1\u5206\u949f!");
            }
            return this.channelService.execute(requestVO);
        }
        catch (Exception e) {
            return ChannelRespondVO.error((ChannelBaseVO)requestVO, (String)("exchange \u64cd\u4f5c\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    private ChannelRespondVO publish(ChannelRequestVO requestVO) {
        try {
            this.channelService.publish(requestVO);
            ChannelRespondVO respondVO = new ChannelRespondVO();
            respondVO.bindBaseVO((ChannelBaseVO)requestVO);
            respondVO.setRecv(null);
            return respondVO;
        }
        catch (Exception e) {
            return ChannelRespondVO.error((ChannelBaseVO)requestVO, (String)("publish \u64cd\u4f5c\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    private ChannelRespondVO manage(ChannelRequestVO requestVO) {
        try {
            return this.channelService.manageChannel(requestVO);
        }
        catch (Exception e) {
            return ChannelRespondVO.error((ChannelBaseVO)requestVO, (String)("publish \u64cd\u4f5c\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }
}

