/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.channel.socket.core.notify;

import cn.foxtech.channel.socket.core.handler.ScriptSplitMessageHandler;
import cn.foxtech.channel.socket.core.script.ScriptEngineService;
import cn.foxtech.channel.socket.core.script.ScriptSplitMessage;
import cn.foxtech.common.entity.entity.BaseEntity;
import cn.foxtech.common.entity.entity.OperateEntity;
import cn.foxtech.common.entity.manager.RedisConsoleService;
import cn.foxtech.common.entity.service.redis.BaseConsumerEntityNotify;
import org.apache.log4j.Logger;

public class OperateEntitySplitNotify
extends BaseConsumerEntityNotify {
    private static final Logger logger = Logger.getLogger(OperateEntitySplitNotify.class);
    private RedisConsoleService console;
    private ScriptEngineService scriptEngineService;
    private OperateEntity operateEntity;
    private String format;
    private ScriptSplitMessageHandler splitMessageHandler = new ScriptSplitMessageHandler();

    public String getServiceKey() {
        return this.operateEntity.makeServiceKey();
    }

    public void notifyInsert(BaseEntity entity) {
        this.reset();
    }

    public void notifyUpdate(BaseEntity entity) {
        this.operateEntity = (OperateEntity)entity;
        this.reset();
    }

    public void reset() {
        try {
            ScriptSplitMessage scriptSplitMessage = this.scriptEngineService.buildSplitOperate(this.operateEntity);
            scriptSplitMessage.setFormat(this.format);
            this.splitMessageHandler.setScriptSplitMessage(scriptSplitMessage);
            this.splitMessageHandler.resetHeader();
        }
        catch (Exception e) {
            String message = "reset\u5f02\u5e38\uff1amanufacturer=" + this.operateEntity.getManufacturer() + "\uff0c deviceType=" + this.operateEntity.getDeviceType() + "\uff0c operateName=" + this.operateEntity.getOperateName() + e.getMessage();
            logger.error((Object)message);
            this.console.error(message);
        }
    }

    public RedisConsoleService getConsole() {
        return this.console;
    }

    public ScriptEngineService getScriptEngineService() {
        return this.scriptEngineService;
    }

    public OperateEntity getOperateEntity() {
        return this.operateEntity;
    }

    public String getFormat() {
        return this.format;
    }

    public ScriptSplitMessageHandler getSplitMessageHandler() {
        return this.splitMessageHandler;
    }

    public void setConsole(RedisConsoleService console) {
        this.console = console;
    }

    public void setScriptEngineService(ScriptEngineService scriptEngineService) {
        this.scriptEngineService = scriptEngineService;
    }

    public void setOperateEntity(OperateEntity operateEntity) {
        this.operateEntity = operateEntity;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setSplitMessageHandler(ScriptSplitMessageHandler splitMessageHandler) {
        this.splitMessageHandler = splitMessageHandler;
    }
}

