/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.channel.socket.core.script;

import cn.foxtech.channel.socket.core.script.ScriptServiceKey;
import cn.foxtech.channel.socket.core.script.ScriptSplitMessage;
import cn.foxtech.common.entity.entity.OperateEntity;
import cn.foxtech.common.utils.MapUtils;
import cn.foxtech.common.utils.hex.HexUtils;
import cn.foxtech.common.utils.method.MethodUtils;
import cn.foxtech.core.exception.ServiceException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.springframework.stereotype.Component;

@Component
public class ScriptEngineService {
    private final ScriptEngineManager manager = new ScriptEngineManager();
    private final Map<String, Object> engineMap = new ConcurrentHashMap<String, Object>();

    public ScriptEngine getScriptEngine(String manufacturer, String deviceType, String operateName) {
        ScriptEngine engine = (ScriptEngine)MapUtils.getValue(this.engineMap, (Object[])new Object[]{manufacturer, deviceType, operateName});
        if (engine == null) {
            engine = this.manager.getEngineByName("JavaScript");
            MapUtils.setValue(this.engineMap, (Object[])new Object[]{manufacturer, deviceType, operateName, engine});
        }
        return engine;
    }

    public ScriptSplitMessage buildSplitOperate(OperateEntity operateEntity) throws ScriptException {
        if (!(operateEntity.getEngineType().equals("JavaScript") && operateEntity.getOperateName().equals("splitHandler") && operateEntity.getOperateMode().equals("splitHandler") && operateEntity.getServiceType().equals("channel"))) {
            throw new ServiceException("\u83b7\u5f97\u64cd\u4f5c\u5b9e\u4f53\uff0c\u4e0d\u662f\u4e00\u4e2aJsp\u5f15\u64ce\u65b9\u6cd5");
        }
        Map decode = (Map)operateEntity.getEngineParam().get("decode");
        if (MethodUtils.hasEmpty((Object[])new Object[]{decode})) {
            throw new ServiceException("engineParam\u4e3a\u7a7a\uff01");
        }
        String decodeScript = (String)decode.get("code");
        if (MethodUtils.hasEmpty((Object[])new Object[]{decodeScript})) {
            throw new ServiceException("\u672a\u5b9a\u4e49\u89e3\u7801\u811a\u672c\uff01");
        }
        ScriptEngine scriptEngine = this.getScriptEngine(operateEntity.getManufacturer(), operateEntity.getDeviceType(), operateEntity.getOperateName());
        scriptEngine.eval(decodeScript);
        Integer headerLength = (Integer)scriptEngine.eval("getHeaderLength()");
        if (headerLength == null || headerLength < 1) {
            throw new ServiceException("\u811a\u672c\u4e2d\u672a\u5b9a\u4e49\u6b63\u786e\u7684\u811a\u672c\uff0c\u8bf7\u81ea\u884c\u53c2\u8003\u6b63\u786e\u7684\u8303\u4f8b\uff1afunction getHeaderLength()");
        }
        byte[] pack = new byte[headerLength.intValue()];
        String hex = HexUtils.byteArrayToHexString((byte[])pack);
        Object value = scriptEngine.eval("getPackLength('" + hex + "')");
        if (value == null) {
            throw new ServiceException("\u811a\u672c\u4e2d\u672a\u5b9a\u4e49\u6b63\u786e\u7684\u811a\u672c\uff0c\u8bf7\u81ea\u884c\u53c2\u8003\u6b63\u786e\u7684\u8303\u4f8b\uff1afunction getPackLength(pack)");
        }
        Boolean invalidPack = (Boolean)scriptEngine.eval("isInvalidPack('" + hex + "')");
        if (invalidPack == null) {
            throw new ServiceException("\u811a\u672c\u4e2d\u672a\u5b9a\u4e49\u6b63\u786e\u7684\u811a\u672c\uff0c\u8bf7\u81ea\u884c\u53c2\u8003\u6b63\u786e\u7684\u8303\u4f8b\uff1afunction getPackLength(pack)");
        }
        ScriptSplitMessage scriptSplitMessage = new ScriptSplitMessage();
        scriptSplitMessage.setScriptEngine(scriptEngine);
        scriptSplitMessage.setScript(decodeScript);
        return scriptSplitMessage;
    }

    public ScriptServiceKey buildServiceKeyOperate(OperateEntity operateEntity) throws ScriptException {
        if (!(operateEntity.getEngineType().equals("JavaScript") && operateEntity.getOperateName().equals("keyHandler") && operateEntity.getOperateMode().equals("keyHandler") && operateEntity.getServiceType().equals("channel"))) {
            throw new ServiceException("\u83b7\u5f97\u64cd\u4f5c\u5b9e\u4f53\uff0c\u4e0d\u662f\u4e00\u4e2aJsp\u5f15\u64ce\u65b9\u6cd5");
        }
        Map decode = (Map)operateEntity.getEngineParam().get("decode");
        if (MethodUtils.hasEmpty((Object[])new Object[]{decode})) {
            throw new ServiceException("engineParam\u4e3a\u7a7a\uff01");
        }
        String decodeScript = (String)decode.get("code");
        if (MethodUtils.hasEmpty((Object[])new Object[]{decodeScript})) {
            throw new ServiceException("\u672a\u5b9a\u4e49\u89e3\u7801\u811a\u672c\uff01");
        }
        ScriptEngine scriptEngine = this.getScriptEngine(operateEntity.getManufacturer(), operateEntity.getDeviceType(), operateEntity.getOperateName());
        scriptEngine.eval(decodeScript);
        byte[] pack = new byte[16];
        String hex = HexUtils.byteArrayToHexString((byte[])pack);
        scriptEngine.eval("getServiceKey('" + hex + "')");
        ScriptServiceKey scriptServiceKey = new ScriptServiceKey();
        scriptServiceKey.setScriptEngine(scriptEngine);
        scriptServiceKey.setScript(decodeScript);
        return scriptServiceKey;
    }
}

