/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.common.mqtt;

import cn.foxtech.common.mqtt.MqttClientListener;
import cn.foxtech.common.mqtt.MqttConfigService;
import java.util.Map;
import net.dreamlu.iot.mqtt.core.client.IMqttClientMessageListener;
import net.dreamlu.iot.mqtt.core.client.MqttClient;
import net.dreamlu.iot.mqtt.core.client.MqttClientCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MqttClientService {
    private static final Logger logger = LoggerFactory.getLogger(MqttClientService.class);
    private final MqttClientCreator creator = MqttClient.create();
    @Autowired
    private MqttConfigService configService;
    private MqttClient mqttClient;
    @Autowired
    private MqttClientListener mqttClientListener;

    public boolean Initialize(Map<String, Object> configs) {
        this.configService.initialize(configs);
        String clientId = this.configService.getClientId();
        String subTopic = this.mqttClientListener.getClientHandler().getTopic();
        logger.info("mqtt clientId       :" + clientId);
        logger.info("mqtt topic subscribe:" + subTopic);
        this.creator.ip(this.configService.getHost());
        this.creator.port(this.configService.getPort().intValue());
        this.creator.name(this.configService.getName());
        this.creator.username(this.configService.getUserName());
        this.creator.password(this.configService.getPassword());
        this.creator.keepAliveSecs(this.configService.getKeepAliveSecs().intValue());
        this.creator.reInterval((long)this.configService.getReInterval().intValue());
        this.creator.clientId(clientId);
        this.mqttClient = this.creator.connect();
        if (subTopic != null && !subTopic.isEmpty()) {
            this.mqttClient.subQos0(subTopic, (IMqttClientMessageListener)this.mqttClientListener);
        }
        return true;
    }

    public MqttClientCreator getCreator() {
        return this.creator;
    }

    public MqttConfigService getConfigService() {
        return this.configService;
    }

    public MqttClient getMqttClient() {
        return this.mqttClient;
    }

    public MqttClientListener getMqttClientListener() {
        return this.mqttClientListener;
    }
}

