/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.common.utils.log4j;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.helpers.CountingQuietWriter;
import org.apache.log4j.helpers.LogLog;

public class RoolingAndDateFileAppender
extends RollingFileAppender {
    private String datePattern;
    private String dateStr = "";
    private String expirDays = "1";
    private String isCleanLog = "false";
    private String maxIndex = "100";
    private File rootDir;
    private final String gzFormat = "gz";

    public String getDatePattern() {
        return this.datePattern;
    }

    public void setDatePattern(String datePattern) {
        if (null != datePattern && !"".equals(datePattern)) {
            this.datePattern = datePattern;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollOver() {
        Boolean boo;
        this.dateStr = new SimpleDateFormat(this.datePattern).format(new Date(System.currentTimeMillis()));
        Object target = null;
        File file = null;
        if (this.qw != null) {
            long size = ((CountingQuietWriter)this.qw).getCount();
            LogLog.debug((String)("rolling over count=" + size));
        }
        LogLog.debug((String)("maxBackupIndex=" + this.maxBackupIndex));
        if (this.maxIndex != null && Integer.parseInt(this.maxIndex) > 0 && (file = new File(this.fileName + '.' + this.dateStr + '.' + Integer.parseInt(this.maxIndex) + '.' + "gz")).exists() && !(boo = this.reLogNum()).booleanValue()) {
            LogLog.debug((String)"\u65e5\u5fd7\u6eda\u52a8\u91cd\u547d\u540d\u5931\u8d25\uff01");
        }
        int count = this.cleanLog();
        this.closeFile();
        file = new File(this.fileName);
        DeflaterOutputStream gzout = null;
        FileInputStream fin = null;
        byte[] buf = new byte[1024];
        try {
            int num;
            fin = new FileInputStream(file);
            gzout = new GZIPOutputStream(new FileOutputStream(this.fileName + "." + this.dateStr + "." + (count + 1) + '.' + "gz"));
            while ((num = fin.read(buf, 0, buf.length)) != -1) {
                ((GZIPOutputStream)gzout).write(buf, 0, num);
            }
            gzout.flush();
            ((GZIPOutputStream)gzout).finish();
            LogLog.debug((String)(this.fileName + " -> " + this.fileName + "." + this.dateStr + "." + (count + 1) + '.' + "gz" + " successful!"));
        }
        catch (IOException e) {
            LogLog.error((String)("add gz file(" + this.fileName + "." + this.dateStr + "." + (count + 1) + '.' + "gz" + ") failed."));
        }
        finally {
            try {
                if (gzout != null) {
                    gzout.close();
                }
                if (fin != null) {
                    fin.close();
                }
            }
            catch (IOException e) {
                LogLog.error((String)"close Stream failed");
            }
        }
        file.delete();
        try {
            this.setFile(this.fileName, false, this.bufferedIO, this.bufferSize);
        }
        catch (IOException e) {
            LogLog.error((String)("setFile(" + this.fileName + ",false)call failed."), (Throwable)e);
        }
    }

    public int cleanLog() {
        int count = 0;
        if (Boolean.parseBoolean(this.isCleanLog)) {
            File[] listFiles;
            File f = new File(this.fileName);
            this.rootDir = f.getParentFile();
            for (File file : listFiles = this.rootDir.listFiles()) {
                String[] split;
                if (file.getName().contains(this.dateStr)) {
                    ++count;
                    continue;
                }
                if (!Boolean.parseBoolean(this.isCleanLog) || (split = file.getName().split("\\\\")[0].split("\\.")).length != 4 || !this.isExpTime(split[2]).booleanValue()) continue;
                file.delete();
            }
        }
        return count;
    }

    public Boolean isExpTime(String time) {
        SimpleDateFormat format = new SimpleDateFormat(this.datePattern);
        try {
            Date logTime = format.parse(time);
            Date nowTime = format.parse(format.format(new Date()));
            int days = (int)(nowTime.getTime() - logTime.getTime()) / 86400000;
            return Math.abs(days) >= Integer.parseInt(this.expirDays);
        }
        catch (Exception e) {
            LogLog.error((String)e.toString());
            return false;
        }
    }

    public Boolean reLogNum() {
        boolean renameTo = false;
        File startFile = new File(this.fileName + '.' + this.dateStr + '.' + "1" + '.' + "gz");
        if (startFile.exists() && startFile.delete()) {
            for (int i = 2; i <= Integer.parseInt(this.maxIndex); ++i) {
                File target = new File(this.fileName + '.' + this.dateStr + '.' + (i - 1) + '.' + "gz");
                this.closeFile();
                File file = new File(this.fileName + '.' + this.dateStr + '.' + i + '.' + "gz");
                renameTo = file.renameTo(target);
            }
        }
        return renameTo;
    }

    public String getDateStr() {
        return this.dateStr;
    }

    public void setDateStr(String dateStr) {
        this.dateStr = dateStr;
    }

    public String getExpirDays() {
        return this.expirDays;
    }

    public void setExpirDays(String expirDays) {
        this.expirDays = expirDays;
    }

    public String getIsCleanLog() {
        return this.isCleanLog;
    }

    public void setIsCleanLog(String isCleanLog) {
        this.isCleanLog = isCleanLog;
    }

    public String getMaxIndex() {
        return this.maxIndex;
    }

    public void setMaxIndex(String maxIndex) {
        this.maxIndex = maxIndex;
    }
}

