/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.tools.common.result;

import java.io.Serializable;
import java.util.List;

public class PageResult<T>
implements Serializable {
    private List<T> data;
    private long totalPages;
    private long currentPage;
    private long totalRows;
    private long pageRows;

    private PageResult() {
    }

    public static <T> PageResult<T> of(List<T> data, long totalPages, long currentPage) {
        PageResult<T> pageResult = new PageResult<T>();
        pageResult.setData(data);
        pageResult.setTotalPages(totalPages);
        pageResult.setCurrentPage(currentPage);
        return pageResult;
    }

    public static <T> PageResult<T> of(List<T> data, long totalPages) {
        PageResult<T> pageResult = new PageResult<T>();
        pageResult.setData(data);
        pageResult.setTotalPages(totalPages);
        return pageResult;
    }

    public static <T> PageResult<T> of(List<T> data, long totalPages, long currentPage, long totalRows) {
        PageResult<T> pageResult = new PageResult<T>();
        pageResult.setData(data);
        pageResult.setTotalPages(totalPages);
        pageResult.setCurrentPage(currentPage);
        pageResult.setTotalRows(totalRows);
        return pageResult;
    }

    public static <T> PageResult<T> of(List<T> data, long totalPages, long currentPage, long totalRows, long pageRows) {
        PageResult<T> pageResult = new PageResult<T>();
        pageResult.setData(data);
        pageResult.setTotalPages(totalPages);
        pageResult.setCurrentPage(currentPage);
        pageResult.setTotalRows(totalRows);
        pageResult.setPageRows(pageRows);
        return pageResult;
    }

    public List<T> getData() {
        return this.data;
    }

    public long getTotalPages() {
        return this.totalPages;
    }

    public long getCurrentPage() {
        return this.currentPage;
    }

    public long getTotalRows() {
        return this.totalRows;
    }

    public long getPageRows() {
        return this.pageRows;
    }

    public void setData(List<T> data) {
        this.data = data;
    }

    public void setTotalPages(long totalPages) {
        this.totalPages = totalPages;
    }

    public void setCurrentPage(long currentPage) {
        this.currentPage = currentPage;
    }

    public void setTotalRows(long totalRows) {
        this.totalRows = totalRows;
    }

    public void setPageRows(long pageRows) {
        this.pageRows = pageRows;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageResult)) {
            return false;
        }
        PageResult other = (PageResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<T> this$data = this.getData();
        List<T> other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        if (this.getTotalPages() != other.getTotalPages()) {
            return false;
        }
        if (this.getCurrentPage() != other.getCurrentPage()) {
            return false;
        }
        if (this.getTotalRows() != other.getTotalRows()) {
            return false;
        }
        return this.getPageRows() == other.getPageRows();
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<T> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        long $totalPages = this.getTotalPages();
        result = result * 59 + (int)($totalPages >>> 32 ^ $totalPages);
        long $currentPage = this.getCurrentPage();
        result = result * 59 + (int)($currentPage >>> 32 ^ $currentPage);
        long $totalRows = this.getTotalRows();
        result = result * 59 + (int)($totalRows >>> 32 ^ $totalRows);
        long $pageRows = this.getPageRows();
        result = result * 59 + (int)($pageRows >>> 32 ^ $pageRows);
        return result;
    }

    public String toString() {
        return "PageResult(data=" + this.getData() + ", totalPages=" + this.getTotalPages() + ", currentPage=" + this.getCurrentPage() + ", totalRows=" + this.getTotalRows() + ", pageRows=" + this.getPageRows() + ")";
    }
}

