/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.tools.common.result;

import java.io.Serializable;
import org.springframework.http.HttpStatus;

public class ResultVO<T>
implements Serializable {
    private Integer code;
    private String message;
    private T data;

    private ResultVO() {
    }

    public static <T> ResultVO<T> success(int code, String message, T data) {
        ResultVO<T> resultVO = new ResultVO<T>();
        resultVO.setData(data);
        resultVO.setCode(code);
        resultVO.setMessage(message);
        return resultVO;
    }

    public static <T> ResultVO<T> success(T data) {
        ResultVO<T> resultVO = new ResultVO<T>();
        resultVO.setData(data);
        resultVO.setCode(HttpStatus.OK.value());
        resultVO.setMessage(HttpStatus.OK.getReasonPhrase());
        return resultVO;
    }

    public static ResultVO<String> success() {
        ResultVO<String> resultVO = new ResultVO<String>();
        resultVO.setCode(HttpStatus.OK.value());
        resultVO.setMessage(HttpStatus.OK.getReasonPhrase());
        return resultVO;
    }

    public static ResultVO<String> error(int code, String message) {
        ResultVO<String> resultVO = new ResultVO<String>();
        resultVO.setCode(code);
        resultVO.setMessage(message);
        return resultVO;
    }

    public static ResultVO<String> error() {
        ResultVO<String> resultVO = new ResultVO<String>();
        resultVO.setCode(HttpStatus.BAD_REQUEST.value());
        resultVO.setMessage(HttpStatus.BAD_REQUEST.getReasonPhrase());
        return resultVO;
    }

    public static ResultVO<String> error(String message) {
        ResultVO<String> resultVO = new ResultVO<String>();
        resultVO.setCode(HttpStatus.BAD_REQUEST.value());
        resultVO.setMessage(message);
        return resultVO;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public T getData() {
        return this.data;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResultVO)) {
            return false;
        }
        ResultVO other = (ResultVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$code = this.getCode();
        Integer other$code = other.getCode();
        if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResultVO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "ResultVO(code=" + this.getCode() + ", message=" + this.getMessage() + ", data=" + this.getData() + ")";
    }
}

