/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.tools.common.util;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public final class BeanUtils {
    private BeanUtils() {
    }

    public static void copyProperties(Object source, Object target, String ... ignores) {
        org.springframework.beans.BeanUtils.copyProperties((Object)source, (Object)target, (String[])ignores);
    }

    public static <T> T copyProperties(Object source, Class<T> target, String ... ignores) {
        T t = null;
        try {
            t = target.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        assert (t != null);
        if (ignores == null) {
            org.springframework.beans.BeanUtils.copyProperties((Object)source, t);
            return t;
        }
        org.springframework.beans.BeanUtils.copyProperties((Object)source, t, (String[])ignores);
        return t;
    }

    public static <T> T toBean(Map<String, ?> map, Class<T> bean) {
        T object = null;
        try {
            PropertyDescriptor[] pro;
            object = bean.newInstance();
            BeanInfo beaninfo = Introspector.getBeanInfo(bean, Object.class);
            for (PropertyDescriptor property : pro = beaninfo.getPropertyDescriptors()) {
                String name = property.getName();
                Object value = map.get(name);
                Method set = property.getWriteMethod();
                set.invoke(object, value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return object;
    }

    public static Map<String, Object> toMap(Object bean) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            PropertyDescriptor[] pro;
            BeanInfo beaninfo = Introspector.getBeanInfo(bean.getClass(), Object.class);
            for (PropertyDescriptor property : pro = beaninfo.getPropertyDescriptors()) {
                String key = property.getName();
                Method get = property.getReadMethod();
                Object value = get.invoke(bean, new Object[0]);
                map.put(key, value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    public static Method findMethod(Class<?> clazz, String methodName, Class<?> ... paramTypes) {
        try {
            return clazz.getMethod(methodName, paramTypes);
        }
        catch (NoSuchMethodException var4) {
            return BeanUtils.findDeclaredMethod(clazz, methodName, paramTypes);
        }
    }

    public static Method findDeclaredMethod(Class<?> clazz, String methodName, Class<?> ... paramTypes) {
        try {
            return clazz.getDeclaredMethod(methodName, paramTypes);
        }
        catch (NoSuchMethodException var4) {
            return clazz.getSuperclass() != null ? BeanUtils.findDeclaredMethod(clazz.getSuperclass(), methodName, paramTypes) : null;
        }
    }

    public static void setFieldValue(Object o, Field field, Object value) {
        try {
            field.setAccessible(true);
            field.set(o, value);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static Object getFieldValue(Object o, Field field) {
        try {
            field.setAccessible(true);
            return field.get(o);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    public static Class<?> getInterfaceType(Class<?> source, Class<?> typeInterface, int paramIndex) {
        Type[] genericInterfaces;
        for (Type type : genericInterfaces = source.getGenericInterfaces()) {
            if (!type.getTypeName().startsWith(typeInterface.getName())) continue;
            ParameterizedType pt = (ParameterizedType)type;
            return (Class)pt.getActualTypeArguments()[paramIndex];
        }
        return null;
    }

    public static Class<?> getGenericType(Type type, int paramIndex) {
        ParameterizedType pt = (ParameterizedType)type;
        return (Class)pt.getActualTypeArguments()[paramIndex];
    }
}

