/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.tools.common.util;

import cn.gjing.tools.common.util.ParamUtils;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;

public final class EmailUtils {
    private String host;
    private String password;
    private String from;

    private EmailUtils() {
    }

    private EmailUtils(String host, String password, String from) {
        if (ParamUtils.multiEmpty(host, password, from)) {
            throw new NullPointerException("Instantiation exception, Parameters cannot be null");
        }
        this.host = host;
        this.password = password;
        this.from = from;
    }

    public static EmailUtils of(String host, String password, String from) {
        return new EmailUtils(host, password, from);
    }

    public boolean sendEmail(String subject, String body, String tos, String copyTo) {
        if (ParamUtils.isEmpty(tos)) {
            throw new NullPointerException("The parameter tos cannot be null");
        }
        try {
            Properties props = this.getProperties();
            Session session = Session.getInstance((Properties)props);
            Message msg = this.setSubjectWithFrom(subject, session);
            this.setRecipient(tos, copyTo, msg);
            MimeMultipart mm = this.getMimeMultipart(body);
            msg.setContent((Multipart)mm);
            msg.saveChanges();
            this.startSend(session, msg);
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
        return true;
    }

    public boolean sendEmail(String subject, String body, String[] files, String tos, String copyTo) {
        if (ParamUtils.isEmpty(tos)) {
            throw new NullPointerException("The parameter tos cannot be null");
        }
        try {
            Properties props = this.getProperties();
            Session session = Session.getInstance((Properties)props);
            Message msg = this.setSubjectWithFrom(subject, session);
            this.setRecipient(tos, copyTo, msg);
            MimeMultipart mm = this.getMimeMultipart(body);
            if (ParamUtils.isNotEmpty(files)) {
                for (String f : files) {
                    MimeBodyPart attachment = new MimeBodyPart();
                    DataHandler dh = new DataHandler((DataSource)new FileDataSource(f));
                    attachment.setDataHandler(dh);
                    attachment.setFileName(MimeUtility.encodeText((String)dh.getName()));
                    mm.addBodyPart((BodyPart)attachment);
                }
            }
            msg.setContent((Multipart)mm);
            msg.saveChanges();
            this.startSend(session, msg);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage());
        }
        return true;
    }

    private Message setSubjectWithFrom(String subject, Session session) throws MessagingException {
        MimeMessage msg = new MimeMessage(session);
        msg.setSubject(subject);
        msg.setFrom((Address)new InternetAddress(this.from));
        return msg;
    }

    private void setRecipient(String tos, String copyTo, Message msg) throws MessagingException {
        if (ParamUtils.split(tos, ",").length == 1) {
            msg.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(tos));
        } else {
            msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)tos));
        }
        if (ParamUtils.isNotEmpty(copyTo)) {
            InternetAddress[] copyToArr = InternetAddress.parse((String)copyTo);
            msg.setRecipients(Message.RecipientType.CC, (Address[])copyToArr);
        }
    }

    private Properties getProperties() {
        Properties props = new Properties();
        props.setProperty("mail.smtp.auth", "true");
        props.setProperty("mail.transport.protocol", "smtp");
        props.put("mail.smtp.host", this.host);
        return props;
    }

    private void startSend(Session session, Message msg) throws MessagingException {
        Transport transport = session.getTransport();
        transport.connect(this.from, this.password);
        transport.sendMessage(msg, msg.getAllRecipients());
        transport.close();
    }

    private MimeMultipart getMimeMultipart(String body) throws MessagingException {
        MimeMultipart mm = new MimeMultipart();
        MimeBodyPart html = new MimeBodyPart();
        html.setContent((Object)body, "text/html;charset=UTF-8");
        mm.addBodyPart((BodyPart)html);
        return mm;
    }
}

