/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.tools.common.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class ParamUtils {
    private ParamUtils() {
    }

    public static <T> boolean isEmpty(T param) {
        if (param == null || "".equals(param)) {
            return true;
        }
        if (param instanceof Collection) {
            return ((Collection)param).isEmpty();
        }
        if (param instanceof Map) {
            return ((Map)param).isEmpty();
        }
        if (param.getClass().isArray()) {
            return Array.getLength(param) == 0;
        }
        return false;
    }

    public static <T> T requireNotNull(T param) {
        if (param == null) {
            throw new NullPointerException("Parameter cannot be null");
        }
        return param;
    }

    public static <T> T requireNotNull(T param, String error) {
        if (param == null) {
            throw new NullPointerException(error);
        }
        return param;
    }

    public static <T> boolean listHasEmpty(Collection<? extends T> list) {
        return list.stream().anyMatch(ParamUtils::isEmpty);
    }

    public static boolean multiEmpty(Object ... params) {
        return Arrays.stream(params).anyMatch(ParamUtils::isEmpty);
    }

    public static <T> boolean isNotEmpty(T param) {
        return !ParamUtils.isEmpty(param);
    }

    public static boolean equals(Object param1, Object param2) {
        return param1 == param2 || ParamUtils.requireNotNull(param1).equals(param2);
    }

    public static String trim(String str) {
        return ParamUtils.isEmpty(str) ? null : str.trim();
    }

    public static List<String> trim(List<String> list) {
        List listNonNull = list.stream().filter(ParamUtils::isNotEmpty).collect(Collectors.toList());
        return listNonNull.size() <= 0 ? null : listNonNull.stream().map(ParamUtils::trim).collect(Collectors.toList());
    }

    public static String removeSymbol(String str, String symbol) {
        if (ParamUtils.isEmpty(str)) {
            return null;
        }
        str = ParamUtils.removeStartSymbol(str, symbol);
        return ParamUtils.removeEndSymbol(str, symbol);
    }

    public static String removeStartSymbol(String str, String symbol) {
        int strLen;
        if (ParamUtils.isNotEmpty(str) && (strLen = str.length()) != 0) {
            int start;
            if (ParamUtils.isEmpty(symbol)) {
                return ParamUtils.trim(str);
            }
            for (start = 0; start != strLen && symbol.indexOf(str.charAt(start)) != -1; ++start) {
            }
            return str.substring(start);
        }
        return ParamUtils.trim(str);
    }

    public static String removeEndSymbol(String str, String symbol) {
        int end;
        if (ParamUtils.isNotEmpty(str) && (end = str.length()) != 0) {
            if (ParamUtils.isEmpty(symbol)) {
                return ParamUtils.trim(str);
            }
            while (end != 0 && symbol.indexOf(str.charAt(end - 1)) != -1) {
                --end;
            }
            return str.substring(0, end);
        }
        return ParamUtils.trim(str);
    }

    public static String[] split(String str, String symbol) {
        if (ParamUtils.isEmpty(str) || symbol.length() != 1) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        int start = 0;
        while (i < str.length()) {
            if (String.valueOf(str.charAt(i)).equals(symbol)) {
                list.add(str.substring(start, i));
                start = ++i;
                continue;
            }
            ++i;
        }
        list.add(str.substring(start));
        return list.toArray(new String[0]);
    }

    public static Map<String, String> paramToMap(String paramStr) {
        if (paramStr == null) {
            return new HashMap<String, String>(16);
        }
        String[] params = paramStr.split("&");
        HashMap<String, String> resMap = new HashMap<String, String>(16);
        for (String s : params) {
            String[] param = s.split("=");
            if (param.length < 2) continue;
            String key = param[0];
            StringBuilder value = new StringBuilder(param[1]);
            for (int j = 2; j < param.length; ++j) {
                value.append("=").append(param[j]);
            }
            resMap.put(key, value.toString());
        }
        return resMap;
    }

    public static String removeAllSymbol(String str, String symbol) {
        if (ParamUtils.isEmpty(str) || symbol.length() > 1) {
            return str;
        }
        StringBuilder builder = new StringBuilder();
        String[] strings = ParamUtils.split(str, symbol);
        if (ParamUtils.isNotEmpty(strings)) {
            for (String s : strings) {
                builder.append(s);
            }
            return builder.toString();
        }
        return null;
    }

    public static boolean contains(String[] arr, String val) {
        if (arr == null) {
            return false;
        }
        for (String s : arr) {
            if (!ParamUtils.equals(s, val)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmail(String email) {
        String regex = "^([a-z0-9_.-]+)@([\\da-z.-]+)\\.([a-z.]{2,6})$";
        return Pattern.compile(regex).matcher(email).matches();
    }

    public static boolean isMobileNumber(String phone) {
        String regex = "^1([3-9])\\d{9}$";
        return Pattern.compile(regex).matcher(phone).matches();
    }

    public static boolean isTelPhone(String tel) {
        String regex = "^(0[0-9]{2,3}-)?([2-9][0-9]{6,7})+(-[0-9]{1,4})?$";
        return Pattern.compile(regex).matcher(tel).matches();
    }

    public static boolean isPostCode(String postCode) {
        String regex = "^\\d{6}$";
        return Pattern.compile(regex).matcher(postCode).matches();
    }

    public static boolean isNumber(String param) {
        String regex = "^(-?\\d+)(\\.\\d+)?$";
        return Pattern.compile(regex).matcher(param).matches();
    }
}

