/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.tools.common.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;

public final class TimeUtils {
    public static SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    public static SimpleDateFormat DATE_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("HH:mm:ss");

    private TimeUtils() {
    }

    public static String dateToText(Date date) {
        return DATE_FORMAT.format(date);
    }

    public static String dateToText(Date date, SimpleDateFormat format) {
        return format.format(date);
    }

    public static String datetimeToText(Date date) {
        return DATE_TIME_FORMAT.format(date);
    }

    public static String dateToText(Date date, String format) {
        SimpleDateFormat format1 = new SimpleDateFormat(format);
        return format1.format(date);
    }

    public static Date textToDate(String date) {
        try {
            return DATE_FORMAT.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return new Date();
        }
    }

    public static Date textToDatetime(String date) {
        try {
            return DATE_TIME_FORMAT.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return new Date();
        }
    }

    public static Date textToDatetime(String date, SimpleDateFormat format) {
        try {
            return format.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return new Date();
        }
    }

    public static Date textToDate(String date, String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        try {
            return dateFormat.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return new Date();
        }
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
    }

    public static LocalDate dateToLocalDate(Date date) {
        return TimeUtils.toLocalDateTime(date).toLocalDate();
    }

    public static Date toDate(LocalDate localDate) {
        return TimeUtils.localDateTimeToDate(localDate.atStartOfDay());
    }

    public static String toText(LocalDate localDate) {
        return localDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
    }

    public static String toText(LocalDateTime localDateTime) {
        return localDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }

    public static String toText(LocalTime localTime) {
        return localTime.format(DateTimeFormatter.ofPattern("HH:mm:ss"));
    }

    public static LocalDate toLocalDate(String date) {
        return LocalDate.parse(date, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
    }

    public static LocalDateTime toLocalDateTime(String dateTime) {
        return LocalDateTime.parse(dateTime, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }

    public static Date localDateTimeToDate(LocalDateTime dateTime) {
        return Date.from(dateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static long toTimestamp(LocalDateTime localDateTime) {
        ZoneId zone = ZoneId.systemDefault();
        Instant instant = localDateTime.atZone(zone).toInstant();
        return instant.toEpochMilli();
    }

    public static Integer getYearsByStartTime(String date) {
        LocalDate startDate1 = TimeUtils.toLocalDate(date);
        LocalDate currentDate = LocalDate.now();
        if (currentDate.isBefore(startDate1)) {
            return 0;
        }
        return startDate1.until(currentDate).getYears();
    }

    public static Integer getYearsByStartTime(LocalDate date) {
        LocalDate currentDate = LocalDate.now();
        if (currentDate.isBefore(date)) {
            return 0;
        }
        return date.until(currentDate).getYears();
    }

    public static LocalDateTime toLocalDateTime(Long timestamp) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneId.systemDefault());
    }

    public static Calendar toCalendar(String date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.setTime(simpleDateFormat.parse(date));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return calendar;
    }

    public static Date toDate(Calendar calendar, String format) {
        return TimeUtils.textToDate(TimeUtils.toText(calendar, format));
    }

    public static String toText(Calendar calendar, String format) {
        return TimeUtils.dateToText(calendar.getTime(), format);
    }

    public static int getAllDaysOfMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.getActualMaximum(5);
    }

    public static int getDays(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(5);
    }

    public static int getYears(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(1);
    }

    public static int getMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(2) + 1;
    }

    public static Date addMonth(Date date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, n);
        return cal.getTime();
    }

    public static Date addDay(Date date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, n);
        return cal.getTime();
    }

    public static Long toTimestamp(String date) {
        return TimeUtils.textToDate(date).getTime();
    }

    public static String toText(Long timeStamp) {
        long l = timeStamp;
        return TimeUtils.dateToText(new Date(l));
    }

    public static int dateBetween(String startDate, String endDate) {
        Date dateStart = TimeUtils.textToDate(startDate, "yyyy-MM-dd");
        Date dateEnd = TimeUtils.textToDate(endDate, "yyyy-MM-dd");
        return (int)((dateEnd.getTime() - dateStart.getTime()) / 1000L / 60L / 60L / 24L);
    }

    public static int dateBetween(Date startDate, Date endDate) {
        return (int)((startDate.getTime() - endDate.getTime()) / 1000L / 60L / 60L / 24L);
    }

    public static int dateBetweenIncludeToday(String startDate, String endDate) {
        return TimeUtils.dateBetween(startDate, endDate) + 1;
    }

    public static int dateBetweenIncludeToday(Date startDate, Date endDate) {
        return TimeUtils.dateBetween(startDate, endDate) + 1;
    }
}

