/*
 * Decompiled with CFR 0.152.
 */
package cn.gybyt.advice;

import cn.gybyt.util.BaseException;
import cn.gybyt.util.BaseResponse;
import cn.gybyt.util.BaseUtil;
import cn.gybyt.util.HttpStatusEnum;
import cn.gybyt.util.LoggerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class GybytControllerExceptionAdvice {
    private final Logger log = LoggerFactory.getLogger(GybytControllerExceptionAdvice.class);

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<Object> methodArgumentNotValidExceptionHandler(Exception e) {
        LinkedMultiValueMap headers = new LinkedMultiValueMap();
        headers.set((Object)"Content-Type", (Object)"application/json;charset=UTF-8");
        LoggerUtil.handleException((Logger)this.log, (Exception)e);
        this.log.error(e.getMessage(), (Throwable)e);
        return new ResponseEntity((Object)BaseResponse.failure((Integer)HttpStatusEnum.SERVERERROR.value(), (String)e.getMessage()), (MultiValueMap)headers, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={BaseException.class})
    public ResponseEntity<Object> apiExceptionHandler(BaseException e) {
        LinkedMultiValueMap headers = new LinkedMultiValueMap();
        headers.set((Object)"Content-Type", (Object)"application/json;charset=UTF-8");
        LoggerUtil.handleException((Logger)this.log, (Exception)e);
        this.log.error(e.getMsg(), (Throwable)e);
        HttpStatus httpStatus = HttpStatus.resolve((int)e.getHttpStatus());
        if (BaseUtil.isNull((Object)httpStatus).booleanValue()) {
            httpStatus = HttpStatus.BAD_REQUEST;
        }
        return new ResponseEntity((Object)BaseResponse.failure((Integer)e.getCode(), (String)e.getMsg()), (MultiValueMap)headers, httpStatus);
    }
}

