/*
 * Decompiled with CFR 0.152.
 */
package cn.gybyt.advice;

import java.util.regex.Pattern;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.stereotype.Component;

@Component
@Aspect
@ConditionalOnClass(value={Aspect.class})
public class LogAdvice {
    private final Logger log = LoggerFactory.getLogger(LogAdvice.class);

    @AfterThrowing(pointcut="execution(* cn.gybyt..*(..))", throwing="e")
    public void throwAdviceLog(Throwable e) {
        StackTraceElement[] stackTrace = e.getStackTrace();
        int post = 0;
        String pattern = ".*\\.java:\\d*\\)";
        String patternEnd = ".*java\\.base/jdk\\.internal.*";
        for (StackTraceElement stackTraceElement : stackTrace) {
            boolean matchesEnd;
            boolean matches = Pattern.matches(pattern, stackTraceElement.toString());
            if (matches) {
                ++post;
            }
            if (matchesEnd = Pattern.matches(patternEnd, stackTraceElement.toString())) break;
        }
        for (int i = 0; i < post; ++i) {
            this.log.error(stackTrace[i].toString());
        }
    }
}

