/*
 * Decompiled with CFR 0.152.
 */
package cn.gybyt.interceptor;

import cn.gybyt.config.properties.GybytMybatisProperties;
import cn.gybyt.util.BaseUtil;
import cn.gybyt.util.ReflectUtil;
import java.lang.reflect.Proxy;
import java.sql.Statement;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.ResultHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=StatementHandler.class, method="query", args={Statement.class, ResultHandler.class}), @Signature(type=StatementHandler.class, method="update", args={Statement.class}), @Signature(type=StatementHandler.class, method="batch", args={Statement.class})})
public class GybytMybatisSqlLogInterceptor
implements Interceptor {
    private final Logger log = LoggerFactory.getLogger(GybytMybatisSqlLogInterceptor.class);
    private Pattern sqlPattern;
    private GybytMybatisProperties gybytMybatisProperties;

    public GybytMybatisSqlLogInterceptor(GybytMybatisProperties gybytMybatisProperties) {
        this.gybytMybatisProperties = gybytMybatisProperties;
        this.sqlPattern = Pattern.compile(String.format(".*(%s)", this.gybytMybatisProperties.getSqlPattern()), 2);
    }

    public Object intercept(Invocation invocation) throws Throwable {
        Object firstArg = invocation.getArgs()[0];
        Statement statement = Proxy.isProxyClass(firstArg.getClass()) ? (Statement)SystemMetaObject.forObject((Object)firstArg).getValue("h.statement") : (Statement)firstArg;
        String sql = statement.toString();
        if (BaseUtil.isNotEmpty((Object)sql).booleanValue()) {
            try {
                sql = sql.replaceAll("\\s+", " ");
                Matcher matcher = this.sqlPattern.matcher(sql);
                matcher.find();
                if (matcher.groupCount() > 0) {
                    sql = matcher.group(1);
                }
            }
            catch (Exception matcher) {
                // empty catch block
            }
        }
        Object delegate = ReflectUtil.getFieldValueByFieldName((Object)invocation.getTarget(), (String)"delegate");
        MappedStatement mappedStatement = (MappedStatement)ReflectUtil.getFieldValueByFieldName((Object)delegate, (String)"mappedStatement");
        long start = System.currentTimeMillis();
        Object result = invocation.proceed();
        long end = System.currentTimeMillis();
        if (BaseUtil.isNotEmpty((Object)sql).booleanValue()) {
            this.log.info("\n==============  Sql Start  ==============\nExecute ID  \uff1a{}\nExecute SQL \uff1a{}\nExecute Time\uff1a{} ms\n==============  Sql  End   ==============\n\n", new Object[]{BaseUtil.isNotEmpty((Object)mappedStatement) != false ? Objects.requireNonNull(mappedStatement).getId() : "", sql, end - start});
        }
        return result;
    }
}

