/*
 * Decompiled with CFR 0.152.
 */
package cn.gybyt.plugins;

import cn.gybyt.util.ReflectUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ibatis.builder.xml.XMLMapperBuilder;
import org.apache.ibatis.builder.xml.XMLMapperEntityResolver;
import org.apache.ibatis.parsing.XNode;
import org.apache.ibatis.parsing.XPathParser;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.xml.sax.EntityResolver;

public class GybytMybatisMapperRefreshPlugin {
    private final Logger log = LoggerFactory.getLogger(GybytMybatisMapperRefreshPlugin.class);
    private SqlSessionFactory sqlSessionFactory;
    private Resource[] mapperLocations;
    private String packageSearchPath;
    private Long refreshInterval;
    private List<String> changeList;
    private HashMap<String, Long> fileMapping = new HashMap();

    public GybytMybatisMapperRefreshPlugin(String packageSearchPath, Long refreshInterval, SqlSessionFactory sqlSessionFactory) {
        this.sqlSessionFactory = sqlSessionFactory;
        this.packageSearchPath = packageSearchPath;
        this.refreshInterval = refreshInterval;
    }

    public void init() {
        GybytMybatisMapperRefreshPlugin ruRefresh = this;
        new Thread(() -> {
            while (true) {
                try {
                    ruRefresh.refreshMapper();
                }
                catch (Exception e1) {
                    this.log.error("\u5237\u65b0\u5931\u8d25");
                }
                try {
                    Thread.sleep(this.refreshInterval * 1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    this.log.error("\u5237\u65b0\u5931\u8d25" + e.getMessage());
                    continue;
                }
                break;
            }
        }, "Thread-Mybatis-Refresh").start();
    }

    private void refreshMapper() {
        try {
            Configuration configuration = this.sqlSessionFactory.getConfiguration();
            try {
                this.scanMapperXml();
            }
            catch (IOException e) {
                this.log.error("\u626b\u63cf\u5305\u8def\u5f84\u914d\u7f6e\u9519\u8bef");
                return;
            }
            if (this.isChanged()) {
                for (Resource resource : this.mapperLocations) {
                    XMLMapperBuilder xmlMapperBuilder = new XMLMapperBuilder(resource.getInputStream(), configuration, resource.toString(), configuration.getSqlFragments());
                    XPathParser xPathParser = new XPathParser(resource.getInputStream(), true, configuration.getVariables(), (EntityResolver)new XMLMapperEntityResolver());
                    XNode xNode = xPathParser.evalNode("/mapper");
                    String namespace = xNode.getStringAttribute("namespace");
                    this.cleanMappedStateMents(xNode.evalNodes("*"), configuration, namespace);
                    this.cleanParameterMap(xNode.evalNodes("/mapper/parameterMap"), configuration, namespace);
                    this.cleanKeyGenerators(xNode.evalNodes("*"), configuration, namespace);
                    this.cleanSqlElement(xNode.evalNodes("/mapper/sql"), configuration, namespace);
                    this.cleanResultMap(xNode.evalNodes("/mapper/resultMap"), configuration, namespace);
                    this.cleanLoadedResource(resource.toString(), configuration);
                    xmlMapperBuilder.parse();
                    if (!this.changeList.contains(resource.getFilename())) continue;
                    this.log.info("[" + resource.getFilename() + "] refresh finished");
                }
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
        }
    }

    private void cleanLoadedResource(String resourceName, Configuration configuration) {
        Set loadedResources = (Set)ReflectUtil.getFieldValueByFieldName((Object)configuration, (String)"loadedResources");
        loadedResources.remove(resourceName);
    }

    private void cleanResultMap(List<XNode> evalNodes, Configuration configuration, String namespace) {
        for (XNode resultMapNode : evalNodes) {
            String id = resultMapNode.getStringAttribute("id", resultMapNode.getValueBasedIdentifier());
            configuration.getResultMapNames().remove(id);
            configuration.getResultMapNames().remove(namespace + "." + id);
            this.clearResultMap(resultMapNode, configuration, namespace);
        }
    }

    private void clearResultMap(XNode xNode, Configuration configuration, String namespace) {
        for (XNode resultChild : xNode.getChildren()) {
            if (!"association".equals(resultChild.getName()) && !"collection".equals(resultChild.getName()) && !"case".equals(resultChild.getName()) || resultChild.getStringAttribute("select") != null) continue;
            configuration.getResultMapNames().remove(resultChild.getStringAttribute("id", resultChild.getValueBasedIdentifier()));
            configuration.getResultMapNames().remove(namespace + "." + resultChild.getStringAttribute("id", resultChild.getValueBasedIdentifier()));
            if (resultChild.getChildren() == null || resultChild.getChildren().isEmpty()) continue;
            this.clearResultMap(resultChild, configuration, namespace);
        }
    }

    private void cleanSqlElement(List<XNode> evalNodes, Configuration configuration, String namespace) {
        for (XNode context : evalNodes) {
            String id = context.getStringAttribute("id");
            configuration.getSqlFragments().remove(id);
            configuration.getSqlFragments().remove(namespace + "." + id);
        }
    }

    private void cleanKeyGenerators(List<XNode> evalNodes, Configuration configuration, String namespace) {
        for (XNode context : evalNodes) {
            String id = context.getStringAttribute("id");
            configuration.getKeyGeneratorNames().remove(id + "!selectKey");
            configuration.getKeyGeneratorNames().remove(namespace + "." + id + "!selectKey");
        }
    }

    private void cleanMappedStateMents(List<XNode> mappedStateMentList, Configuration configuration, String namespace) {
        Map mappedStatements = (Map)ReflectUtil.getFieldValueByFieldName((Object)configuration, (String)"mappedStatements");
        mappedStateMentList.forEach(mappedStateMent -> {
            String id = mappedStateMent.getStringAttribute("id");
            mappedStatements.remove(id);
            mappedStatements.remove(namespace + "." + id);
        });
    }

    private void scanMapperXml() throws IOException {
        this.mapperLocations = new PathMatchingResourcePatternResolver().getResources(this.packageSearchPath);
    }

    private boolean isChanged() throws IOException {
        boolean flag = false;
        this.changeList = new ArrayList<String>();
        for (Resource resource : this.mapperLocations) {
            boolean modifyFlag;
            String resourceName = resource.getFilename();
            boolean addFlag = !this.fileMapping.containsKey(resourceName);
            Long compareFrame = this.fileMapping.get(resourceName);
            long lastFrame = resource.contentLength() + resource.lastModified();
            boolean bl = modifyFlag = null != compareFrame && compareFrame != lastFrame;
            if (!addFlag && !modifyFlag) continue;
            this.fileMapping.put(resourceName, lastFrame);
            flag = true;
            this.changeList.add(resource.getFilename());
        }
        return flag;
    }

    private void cleanParameterMap(List<XNode> list, Configuration configuration, String namespace) {
        for (XNode parameterMapNode : list) {
            String id = parameterMapNode.getStringAttribute("id");
            configuration.getParameterMaps().remove(namespace + "." + id);
        }
    }
}

