/*
 * Decompiled with CFR 0.152.
 */
package cn.gybyt.util;

import cn.gybyt.util.BaseUtil;
import cn.gybyt.util.SpringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.SerializationException;

public class CacheUtil {
    private static RedisTemplate redisTemplate = SpringUtil.getBean(RedisTemplate.class, "gybytRedisTemplate");
    private static RedisTemplate stringRedisTemplate = SpringUtil.getBean(RedisTemplate.class, "gybytRedisStringTemplate");

    public static <T> T get(String cacheName, String preKey, String key, Callable<T> callable, Long timeout) {
        Object t;
        try {
            t = redisTemplate.opsForValue().get((Object)CacheUtil.genKey(cacheName, preKey, key));
        }
        catch (SerializationException e) {
            t = stringRedisTemplate.opsForValue().get((Object)CacheUtil.genKey(cacheName, preKey, key));
        }
        if (BaseUtil.isNull((Object)t).booleanValue()) {
            t = callable.call();
            CacheUtil.set(CacheUtil.genKey(cacheName, preKey, key), t, timeout);
        }
        return (T)t;
    }

    public static <T> T get(String cacheName, String preKey, String key, Callable<T> callable) {
        Object t;
        try {
            t = redisTemplate.opsForValue().get((Object)CacheUtil.genKey(cacheName, preKey, key));
        }
        catch (SerializationException e) {
            t = stringRedisTemplate.opsForValue().get((Object)CacheUtil.genKey(cacheName, preKey, key));
        }
        if (BaseUtil.isNull((Object)t).booleanValue()) {
            t = callable.call();
            CacheUtil.set(CacheUtil.genKey(cacheName, preKey, key), t, null);
        }
        return (T)t;
    }

    public static <T> T get(String cacheName, String preKey, String key) {
        Object t;
        try {
            t = redisTemplate.opsForValue().get((Object)CacheUtil.genKey(cacheName, preKey, key));
        }
        catch (SerializationException e) {
            t = stringRedisTemplate.opsForValue().get((Object)CacheUtil.genKey(cacheName, preKey, key));
        }
        return (T)t;
    }

    public static <T> T get(String key, Callable<T> callable, Long timeout) {
        Object t;
        try {
            t = redisTemplate.opsForValue().get((Object)key);
        }
        catch (SerializationException e) {
            t = stringRedisTemplate.opsForValue().get((Object)key);
        }
        if (BaseUtil.isNull((Object)t).booleanValue()) {
            t = callable.call();
            CacheUtil.set(key, t, timeout);
        }
        return (T)t;
    }

    public static <T> T get(String key, Callable<T> callable) {
        Object t;
        try {
            t = redisTemplate.opsForValue().get((Object)key);
        }
        catch (SerializationException e) {
            t = stringRedisTemplate.opsForValue().get((Object)key);
        }
        if (BaseUtil.isNull((Object)t).booleanValue()) {
            t = callable.call();
            CacheUtil.set(key, t, null);
        }
        return (T)t;
    }

    public static <T> T get(String key) {
        Object t;
        try {
            t = redisTemplate.opsForValue().get((Object)key);
        }
        catch (SerializationException e) {
            t = stringRedisTemplate.opsForValue().get((Object)key);
        }
        return (T)t;
    }

    public static <T> T getHash(String key, Object hashKey) {
        Object t;
        try {
            t = redisTemplate.opsForHash().get((Object)key, hashKey);
        }
        catch (SerializationException e) {
            t = stringRedisTemplate.opsForHash().get((Object)key, hashKey);
        }
        return (T)t;
    }

    public static <T> T getHash(String key, Object hashKey, Callable<T> callable) {
        Object t;
        try {
            t = redisTemplate.opsForHash().get((Object)key, hashKey);
        }
        catch (SerializationException e) {
            t = stringRedisTemplate.opsForHash().get((Object)key, hashKey);
        }
        if (BaseUtil.isNull((Object)t).booleanValue()) {
            t = callable.call();
            CacheUtil.setHash(key, hashKey, t, null);
        }
        return (T)t;
    }

    public static <T> T getHash(String key, Object hashKey, Callable<T> callable, Long timeout) {
        Object t;
        try {
            t = redisTemplate.opsForHash().get((Object)key, hashKey);
        }
        catch (SerializationException e) {
            t = stringRedisTemplate.opsForHash().get((Object)key, hashKey);
        }
        if (BaseUtil.isNull((Object)t).booleanValue()) {
            t = callable.call();
            CacheUtil.setHash(key, hashKey, t, timeout);
        }
        return (T)t;
    }

    public static <T> T getHash(String cacheName, String preKey, String key, Object hashKey) {
        Object t;
        try {
            t = redisTemplate.opsForHash().get((Object)CacheUtil.genKey(cacheName, preKey, key), hashKey);
        }
        catch (SerializationException e) {
            t = stringRedisTemplate.opsForHash().get((Object)CacheUtil.genKey(cacheName, preKey, key), hashKey);
        }
        return (T)t;
    }

    public static <T> T getHash(String cacheName, String preKey, String key, Object hashKey, Callable<T> callable) {
        Object t;
        try {
            t = redisTemplate.opsForHash().get((Object)CacheUtil.genKey(cacheName, preKey, key), hashKey);
        }
        catch (SerializationException e) {
            t = stringRedisTemplate.opsForHash().get((Object)CacheUtil.genKey(cacheName, preKey, key), hashKey);
        }
        if (BaseUtil.isNull((Object)t).booleanValue()) {
            t = callable.call();
            CacheUtil.setHash(key, hashKey, t, null);
        }
        return (T)t;
    }

    public static <T> T getHash(String cacheName, String preKey, String key, Object hashKey, Callable<T> callable, Long timeout) {
        Object t;
        try {
            t = redisTemplate.opsForHash().get((Object)CacheUtil.genKey(cacheName, preKey, key), hashKey);
        }
        catch (SerializationException e) {
            t = stringRedisTemplate.opsForHash().get((Object)CacheUtil.genKey(cacheName, preKey, key), hashKey);
        }
        if (BaseUtil.isNull((Object)t).booleanValue()) {
            t = callable.call();
            CacheUtil.setHash(key, hashKey, t, timeout);
        }
        return (T)t;
    }

    public static void set(String key, Object o, Long timeout) {
        if (BaseUtil.isNull((Object)o).booleanValue()) {
            return;
        }
        if (BaseUtil.isNull((Object)timeout).booleanValue()) {
            timeout = 86400000L;
        }
        if (timeout == -1L) {
            if (o instanceof String) {
                stringRedisTemplate.opsForValue().set((Object)key, o);
                return;
            }
            redisTemplate.opsForValue().set((Object)key, o);
        }
        if (o instanceof String) {
            stringRedisTemplate.opsForValue().set((Object)key, o, CacheUtil.genRandomTimeout(timeout), TimeUnit.MILLISECONDS);
            return;
        }
        redisTemplate.opsForValue().set((Object)key, o, CacheUtil.genRandomTimeout(timeout), TimeUnit.MILLISECONDS);
    }

    public static void set(String key, Object o) {
        if (BaseUtil.isNull((Object)o).booleanValue()) {
            return;
        }
        if (o instanceof String) {
            stringRedisTemplate.opsForValue().set((Object)key, o, CacheUtil.genRandomTimeout(86400000L), TimeUnit.MILLISECONDS);
            return;
        }
        redisTemplate.opsForValue().set((Object)key, o, CacheUtil.genRandomTimeout(86400000L), TimeUnit.MILLISECONDS);
    }

    public static void setHash(String key, Object hashKey, Object o, Long timeout) {
        if (BaseUtil.isNull((Object)o).booleanValue()) {
            return;
        }
        if (BaseUtil.isNull((Object)timeout).booleanValue()) {
            timeout = 86400000L;
        }
        if (timeout == -1L) {
            if (o instanceof String) {
                stringRedisTemplate.opsForHash().put((Object)key, hashKey, o);
                return;
            }
            redisTemplate.opsForHash().put((Object)key, hashKey, o);
        }
        if (o instanceof String) {
            stringRedisTemplate.opsForHash().put((Object)key, hashKey, o);
            stringRedisTemplate.expire((Object)key, CacheUtil.genRandomTimeout(timeout), TimeUnit.MILLISECONDS);
            return;
        }
        redisTemplate.opsForHash().put((Object)key, hashKey, o);
        redisTemplate.expire((Object)key, CacheUtil.genRandomTimeout(timeout), TimeUnit.MILLISECONDS);
    }

    public static Long getHashSize(String key) {
        return redisTemplate.opsForHash().size((Object)key);
    }

    public static <T, R> Map<T, R> getHashMap(String key) {
        try {
            return redisTemplate.opsForHash().entries((Object)key);
        }
        catch (SerializationException e) {
            return stringRedisTemplate.opsForHash().entries((Object)key);
        }
    }

    public static void setHash(String key, Object hashKey, Object o) {
        if (BaseUtil.isNull((Object)o).booleanValue()) {
            return;
        }
        redisTemplate.opsForHash().put((Object)key, hashKey, o);
        redisTemplate.expire((Object)key, CacheUtil.genRandomTimeout(86400000L), TimeUnit.MILLISECONDS);
    }

    public static void setHash(String key, Map<?, ?> map, Long timeout) {
        if (BaseUtil.isNull(map).booleanValue()) {
            return;
        }
        if (BaseUtil.isNull((Object)timeout).booleanValue()) {
            timeout = 86400000L;
        }
        redisTemplate.opsForHash().putAll((Object)key, map);
        if (timeout == -1L) {
            return;
        }
        redisTemplate.expire((Object)key, CacheUtil.genRandomTimeout(timeout), TimeUnit.MILLISECONDS);
    }

    public static void setHash(String key, Map<?, ?> map) {
        if (BaseUtil.isNull(map).booleanValue()) {
            return;
        }
        redisTemplate.opsForHash().putAll((Object)key, map);
        redisTemplate.expire((Object)key, CacheUtil.genRandomTimeout(86400000L), TimeUnit.MILLISECONDS);
    }

    public static Boolean hasKey(String key) {
        return redisTemplate.hasKey((Object)key);
    }

    public static Boolean hasKey(String cacheName, String preKey, String key) {
        return redisTemplate.hasKey((Object)CacheUtil.genKey(cacheName, preKey, key));
    }

    public static Boolean hasHashKey(String key, Object hashKey) {
        return redisTemplate.opsForHash().hasKey((Object)key, hashKey);
    }

    public static Boolean hasHashKey(String cacheName, String preKey, String key, Object hashKey) {
        return redisTemplate.opsForHash().hasKey((Object)CacheUtil.genKey(cacheName, preKey, key), hashKey);
    }

    public static void remove(String cacheName, String preKey, String key) {
        redisTemplate.delete((Object)CacheUtil.genKey(cacheName, preKey, key));
    }

    public static void remove(String cacheName, String preKey, List<String> keyList) {
        redisTemplate.delete(CacheUtil.genKeyList(cacheName, preKey, keyList));
    }

    public static void remove(String key) {
        redisTemplate.delete((Object)key);
    }

    public static void remove(List<String> key) {
        redisTemplate.delete(key);
    }

    public static void removeHash(String key, Object hashKey) {
        redisTemplate.opsForHash().delete((Object)key, new Object[]{hashKey});
    }

    public static void removeHash(String key, List<Object> hashKey) {
        redisTemplate.opsForHash().delete((Object)key, new Object[]{hashKey});
    }

    public static void removeHash(String cacheName, String preKey, String key, List<Object> hashKey) {
        redisTemplate.opsForHash().delete((Object)CacheUtil.genKey(cacheName, preKey, key), new Object[]{hashKey});
    }

    public static void removeHash(String cacheName, String preKey, String key, Object hashKey) {
        redisTemplate.opsForHash().delete((Object)CacheUtil.genKey(cacheName, preKey, key), new Object[]{hashKey});
    }

    private static String genKey(String cacheName, String preKey, String key) {
        return String.format("%s:%s:%s", cacheName, preKey, key);
    }

    private static List<String> genKeyList(String cacheName, String preKey, List<String> keyList) {
        ArrayList<String> keys = new ArrayList<String>();
        if (BaseUtil.isEmpty(keyList).booleanValue()) {
            return keys;
        }
        keyList.forEach(key -> keys.add(String.format("%s:%s:%s", cacheName, preKey, key)));
        return keys;
    }

    private static long genRandomTimeout(Long timeout) {
        Random random = new Random();
        return timeout + (long)random.nextInt(1000);
    }
}

