/*
 * Decompiled with CFR 0.152.
 */
package cn.gybyt.util;

import cn.gybyt.util.BaseException;
import cn.gybyt.util.BaseUtil;
import cn.gybyt.util.SpringUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Set;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class HttpUtil {
    private static RestTemplate restTemplate = SpringUtil.getBean(RestTemplate.class);

    public static <T> ResponseEntity<T> fetch(String url, HttpMethod method, Object body, MultiValueMap<String, String> headerMap, Map<String, Object> uriVariables, ParameterizedTypeReference<T> type) {
        RequestEntity requestEntity = null;
        if (BaseUtil.isEmpty(headerMap).booleanValue()) {
            headerMap = new HttpHeaders();
        }
        if (BaseUtil.isEmpty(type).booleanValue()) {
            type = new ParameterizedTypeReference<String>(){};
        }
        if (BaseUtil.isNotEmpty(uriVariables).booleanValue()) {
            Set<String> keys = uriVariables.keySet();
            StringBuilder urlBuild = new StringBuilder();
            url = url + "?";
            keys.forEach(key -> {
                if (urlBuild.length() > 0) {
                    urlBuild.append("&");
                    urlBuild.append((String)key);
                    urlBuild.append("=");
                    urlBuild.append(uriVariables.get(key));
                } else {
                    urlBuild.append((String)key);
                    urlBuild.append("=");
                    urlBuild.append(uriVariables.get(key));
                }
            });
            url = url + urlBuild.toString();
        }
        try {
            requestEntity = new RequestEntity(body, (MultiValueMap)headerMap, HttpMethod.GET, new URI(url));
        }
        catch (URISyntaxException keys) {
            // empty catch block
        }
        try {
            return restTemplate.exchange(new URI(url), method, (HttpEntity)requestEntity, (ParameterizedTypeReference)type);
        }
        catch (URISyntaxException e) {
            throw new BaseException("\u8bf7\u6c42\u5931\u8d25");
        }
    }
}

