/*
 * Decompiled with CFR 0.152.
 */
package cn.gybyt.util;

import cn.gybyt.util.BaseUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpUtil {
    private static final Logger log = LoggerFactory.getLogger(IpUtil.class);

    public static String getRealRequestIp(HttpServletRequest request) {
        List ipList;
        String ip = request.getHeader("X-Real-IP");
        if (BaseUtil.isEmpty((Object)ip).booleanValue() || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("x-forwarded-for");
        }
        if (BaseUtil.isEmpty((Object)ip).booleanValue() || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (BaseUtil.isEmpty((Object)ip).booleanValue() || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (BaseUtil.isEmpty((Object)ip).booleanValue() || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (BaseUtil.isEmpty((Object)ip).booleanValue() || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if ((BaseUtil.isEmpty((Object)ip).booleanValue() || "unknown".equalsIgnoreCase(ip)) && ("127.0.0.1".equals(ip = request.getRemoteAddr()) || "0:0:0:0:0:0:0:1".equals(ip))) {
            try {
                ip = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                log.error("\u83b7\u53d6\u672c\u673aip\u5730\u5740\u5931\u8d25");
            }
        }
        if (BaseUtil.isEmpty((Object)(ipList = BaseUtil.toList((CharSequence)ip, (String)","))).booleanValue()) {
            return "";
        }
        return (String)ipList.get(0);
    }
}

