/*
 * Decompiled with CFR 0.152.
 */
package cn.gybyt.util;

import cn.gybyt.config.properties.JwtProperties;
import cn.gybyt.util.BaseException;
import cn.gybyt.util.BaseUtil;
import cn.gybyt.util.CacheUtil;
import cn.gybyt.util.HttpStatusEnum;
import cn.gybyt.util.SpringUtil;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTCreator;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.exceptions.TokenExpiredException;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class JwtUtil {
    private static JwtProperties jwtProperties;

    public static JwtProperties getJwtProperties() {
        if (jwtProperties == null) {
            jwtProperties = (JwtProperties)SpringUtil.getBean("jwtProperties");
        }
        return jwtProperties;
    }

    public static String createToken(Map<String, String> map) {
        String token = JwtUtil.getJwtProperties().getTokenPrefix();
        JWTCreator.Builder builder = JWT.create();
        for (String key : map.keySet()) {
            builder.withClaim(key, map.get(key));
        }
        String tokenContent = builder.withExpiresAt(new Date(System.currentTimeMillis() + (long)JwtUtil.getJwtProperties().getExpireTime().intValue() * 1000L * 60L)).sign(Algorithm.HMAC512((String)JwtUtil.getJwtProperties().getSecret()));
        token = token + tokenContent;
        return token;
    }

    public static String validateToken(String token) {
        try {
            return ((Claim)JWT.require((Algorithm)Algorithm.HMAC512((String)JwtUtil.getJwtProperties().getSecret())).build().verify(token.replace(JwtUtil.getJwtProperties().getTokenPrefix(), "")).getClaims().get("username")).asString();
        }
        catch (TokenExpiredException e) {
            throw new BaseException(Integer.valueOf(HttpStatusEnum.UNAUTHORIZED.value()), "token\u5df2\u7ecf\u8fc7\u671f");
        }
        catch (Exception e) {
            throw new BaseException(Integer.valueOf(HttpStatusEnum.UNAUTHORIZED.value()), "token\u9a8c\u8bc1\u5931\u8d25");
        }
    }

    public static boolean isNeedUpdate(String token) {
        Date expiresAt = null;
        try {
            expiresAt = JWT.require((Algorithm)Algorithm.HMAC512((String)JwtUtil.getJwtProperties().getSecret())).build().verify(token.replace(JwtUtil.getJwtProperties().getTokenPrefix(), "")).getExpiresAt();
        }
        catch (TokenExpiredException e) {
            return true;
        }
        catch (Exception e) {
            throw new BaseException(Integer.valueOf(HttpStatusEnum.UNAUTHORIZED.value()), "token\u9a8c\u8bc1\u5931\u8d25");
        }
        return expiresAt.getTime() - System.currentTimeMillis() < (long)JwtUtil.getJwtProperties().getExpireTime().intValue() * 1000L * 60L >> 1;
    }

    public static <T> T getLoginUser() {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        String token = request.getHeader(jwtProperties.getHeader());
        token = token.replace(jwtProperties.getTokenPrefix(), "");
        try {
            DecodedJWT jwt = JWT.decode((String)token);
            Map claims = jwt.getClaims();
            Claim usernameClaim = (Claim)claims.get("username");
            String username = usernameClaim.asString();
            Object t = CacheUtil.get(jwtProperties.getKeyPrefix() + username);
            if (BaseUtil.isNull(t).booleanValue()) {
                throw new BaseException(Integer.valueOf(HttpStatusEnum.UNAUTHORIZED.value()), "\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
            }
            return t;
        }
        catch (JWTDecodeException exception) {
            throw new BaseException(Integer.valueOf(HttpStatusEnum.UNAUTHORIZED.value()), "\u89e3\u6790token\u5931\u8d25");
        }
    }
}

