/*
 * Decompiled with CFR 0.152.
 */
package cn.gybyt.util;

import cn.gybyt.util.BaseUtil;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component(value="gybytSpringUtil")
public class SpringUtil
implements BeanFactoryPostProcessor,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(SpringUtil.class);
    private static ApplicationContext context;
    private static ConfigurableListableBeanFactory beanFactory;

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        SpringUtil.context = context;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        SpringUtil.beanFactory = beanFactory;
    }

    private static ListableBeanFactory getBeanFactory() {
        if (BaseUtil.isNull((Object)context).booleanValue()) {
            return beanFactory;
        }
        return context;
    }

    public static <T> T getBean(Class<T> clazz) {
        if (clazz == null) {
            return null;
        }
        return (T)SpringUtil.getBeanFactory().getBean(clazz);
    }

    public static <T> T getBean(String beanName) {
        if (BaseUtil.isEmpty((Object)beanName).booleanValue()) {
            return null;
        }
        return (T)SpringUtil.getBeanFactory().getBean(beanName);
    }

    public static <T> T getBean(Class<T> clazz, String beanName) {
        if (BaseUtil.isEmpty((Object)beanName).booleanValue() || "".equals(beanName.trim())) {
            return null;
        }
        if (clazz == null) {
            return null;
        }
        return (T)SpringUtil.getBeanFactory().getBean(beanName, clazz);
    }

    public static <T> Map<String, T> getBeansOfType(Class<T> clazz) {
        if (clazz == null) {
            return null;
        }
        return SpringUtil.getBeanFactory().getBeansOfType(clazz);
    }

    public static ApplicationContext getContext() {
        if (context == null) {
            return null;
        }
        return context;
    }

    public static void publishEvent(ApplicationEvent event) {
        if (context == null) {
            return;
        }
        try {
            context.publishEvent(event);
        }
        catch (Exception ex) {
            log.error(ex.getMessage());
        }
    }

    public static HttpServletRequest getServletRequest() {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (BaseUtil.isNull((Object)requestAttributes).booleanValue()) {
            return null;
        }
        return requestAttributes.getRequest();
    }

    public static HttpServletResponse getServletResponse() {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (BaseUtil.isNull((Object)requestAttributes).booleanValue()) {
            return null;
        }
        return requestAttributes.getResponse();
    }

    public static Map<String, String> getRequestParam() {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        HttpServletRequest request = SpringUtil.getServletRequest();
        if (BaseUtil.isNull((Object)request).booleanValue()) {
            return new HashMap<String, String>(0);
        }
        Enumeration parameterNames = request.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String key = (String)parameterNames.nextElement();
            paramMap.put(key, request.getParameter(key));
        }
        return paramMap;
    }

    public static String getRequestBody() {
        HttpServletRequest request = SpringUtil.getServletRequest();
        if (BaseUtil.isNull((Object)request).booleanValue()) {
            return "";
        }
        StringBuffer bodyBuffer = new StringBuffer();
        if (request.getContentLength() != -1) {
            try (BufferedReader reader = request.getReader();){
                String line;
                while ((line = reader.readLine()) != null) {
                    bodyBuffer.append(line);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return bodyBuffer.toString();
    }

    public static byte[] getRequestBodyByte() {
        byte[] body;
        HttpServletRequest request = SpringUtil.getServletRequest();
        if (BaseUtil.isNull((Object)request).booleanValue()) {
            return new byte[0];
        }
        if (request.getContentLength() != -1) {
            try {
                int len;
                byte[] bytes = new byte[1024];
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ServletInputStream inputStream = request.getInputStream();
                while ((len = inputStream.read(bytes)) != -1) {
                    byteArrayOutputStream.write(bytes, 0, len);
                }
                body = byteArrayOutputStream.toByteArray();
            }
            catch (IOException e) {
                body = new byte[]{};
            }
        } else {
            body = new byte[]{};
        }
        return body;
    }

    public static Map<String, String> getRequestHeaders() {
        HashMap<String, String> headersMap = new HashMap<String, String>();
        HttpServletRequest request = SpringUtil.getServletRequest();
        if (BaseUtil.isNull((Object)request).booleanValue()) {
            return new HashMap<String, String>(0);
        }
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String key = (String)headerNames.nextElement();
            headersMap.put(key, request.getHeader(key));
        }
        return headersMap;
    }

    public static Map<String, String> getResponseHeaders() {
        HashMap<String, String> headersMap = new HashMap<String, String>();
        HttpServletResponse response = SpringUtil.getServletResponse();
        if (BaseUtil.isNull((Object)response).booleanValue()) {
            return new HashMap<String, String>(0);
        }
        Collection headerNames = response.getHeaderNames();
        headerNames.forEach(headerName -> headersMap.put((String)headerName, response.getHeader(headerName)));
        return headersMap;
    }

    public static synchronized void addProperty(String key, String value, Boolean isReplace) {
        Properties properties = System.getProperties();
        if (BaseUtil.isNotNull((Object)properties.getProperty(key)).booleanValue() && !isReplace.booleanValue()) {
            return;
        }
        properties.setProperty(key, value);
    }

    public static synchronized void addProperty(Object key, Object value, Boolean isReplace) {
        Properties properties = System.getProperties();
        if (BaseUtil.isNotNull((Object)properties.get(key)).booleanValue() && !isReplace.booleanValue()) {
            return;
        }
        properties.put(key, value);
    }

    public static synchronized void addProperty(Map<Object, Object> map, Boolean isReplace) {
        Properties properties = System.getProperties();
        map.keySet().forEach(key -> {
            if (BaseUtil.isNotNull((Object)properties.get(key)).booleanValue() && !isReplace.booleanValue()) {
                return;
            }
            properties.put(key, map.get(key));
        });
    }

    public static String getProperty(String key) {
        Properties properties = System.getProperties();
        return properties.getProperty(key);
    }

    public static Object getProperty(Object key) {
        Properties properties = System.getProperties();
        return properties.get(key);
    }

    public static Map<Object, Object> getPropertiesMap() {
        Properties properties = System.getProperties();
        Set<Object> keySet = properties.keySet();
        ConcurrentHashMap<Object, Object> propertiesMap = new ConcurrentHashMap<Object, Object>();
        keySet.forEach(key -> propertiesMap.put(key, properties.get(key)));
        return propertiesMap;
    }

    public static Map<Object, Object> getPropertiesMap(Set<Object> keySet) {
        Properties properties = System.getProperties();
        ConcurrentHashMap<Object, Object> propertiesMap = new ConcurrentHashMap<Object, Object>();
        keySet.forEach(key -> propertiesMap.put(key, properties.get(key)));
        return propertiesMap;
    }
}

