/*
 * Decompiled with CFR 0.152.
 */
package cn.hangsman.operationlog.interceptor;

import cn.hangsman.operationlog.OperationLog;
import cn.hangsman.operationlog.interceptor.OperationLogInvoker;
import cn.hangsman.operationlog.interceptor.OperationLogParam;
import cn.hangsman.operationlog.interceptor.OperationLogSource;
import cn.hangsman.operationlog.service.DefaultOperationLogRecorder;
import cn.hangsman.operationlog.service.DefaultOperatorService;
import cn.hangsman.operationlog.service.OperationLogRecorder;
import cn.hangsman.operationlog.service.OperatorService;
import cn.hangsman.operationlog.spel.SpelFunctionExpressionParser;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.expression.AnnotatedElementKey;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class OperationLogAspectSupport
implements InitializingBean {
    private final Map<LogOperationCacheKey, LogOperationMetadata> metadataCache = new ConcurrentHashMap<LogOperationCacheKey, LogOperationMetadata>(512);
    private OperatorService operatorService = new DefaultOperatorService();
    private OperationLogRecorder operationLogRecorder = new DefaultOperationLogRecorder();
    private OperationLogSource operationSource;
    private SpelFunctionExpressionParser expressionParser;

    protected Object execute(OperationLogInvoker invoker, Object target, Method method, Object[] args) {
        Class<?> targetClass = this.getTargetClass(target);
        OperationLogSource operationSource = this.getOperationSource();
        Collection<OperationLogParam> operations = operationSource.getLogOperations(method, targetClass);
        if (!CollectionUtils.isEmpty(operations)) {
            OperationLogParam operation = operations.iterator().next();
            EvaluationContext evaluationContext = this.getExpressionParser().createEvaluationContext(method, args);
            LogOperationMetadata metadata = this.getLogOperationMetadata(operation, method, targetClass);
            this.recordLog(invoker, metadata, evaluationContext);
        } else {
            invoker.invoke();
        }
        if (invoker.getThrowableWrapper() != null) {
            throw invoker.getThrowableWrapper();
        }
        return invoker.getRetValue();
    }

    private void recordLog(OperationLogInvoker invoker, LogOperationMetadata metadata, EvaluationContext evaluationContext) {
        for (String variableName : metadata.variableExpressionMap.keySet()) {
            Expression expression = (Expression)metadata.variableExpressionMap.get(variableName);
            evaluationContext.setVariable(variableName, expression.getValue(evaluationContext));
        }
        Date operationTime = new Date();
        invoker.invoke();
        evaluationContext.setVariable("_ret", invoker.getRetValue());
        OperationLogInvoker.ThrowableWrapper throwableWrapper = invoker.getThrowableWrapper();
        evaluationContext.setVariable("_errorMsg", (Object)(throwableWrapper != null ? throwableWrapper.getMessage() : null));
        if (this.isConditionPassing(metadata, evaluationContext)) {
            OperationLog.OperationLogBuilder builder = OperationLog.builder();
            Map expressionMap = metadata.templateExpressionMap;
            OperationLogParam operation = metadata.operation;
            if (throwableWrapper == null) {
                builder.content((String)((Expression)expressionMap.get(operation.content)).getValue(evaluationContext, String.class));
            } else {
                builder.fail((String)((Expression)expressionMap.get(operation.fail)).getValue(evaluationContext, String.class));
            }
            builder.detail((String)((Expression)expressionMap.get(operation.detail)).getValue(evaluationContext, String.class));
            builder.operator(this.getOperatorService().getOperator());
            builder.operatingTime(operationTime);
            builder.category(((LogOperationMetadata)metadata).operation.category);
            this.operationLogRecorder.record(builder.build());
        }
    }

    private boolean isConditionPassing(LogOperationMetadata metadata, EvaluationContext evaluationContext) {
        if (StringUtils.hasText((String)((LogOperationMetadata)metadata).operation.condition)) {
            Expression expression = (Expression)metadata.templateExpressionMap.get(((LogOperationMetadata)metadata).operation.condition);
            Boolean expressionValue = (Boolean)expression.getValue(evaluationContext, Boolean.class);
            return Boolean.TRUE.equals(expressionValue);
        }
        return true;
    }

    private Class<?> getTargetClass(Object target) {
        return AopProxyUtils.ultimateTargetClass((Object)target);
    }

    protected LogOperationMetadata getLogOperationMetadata(OperationLogParam operation, Method method, Class<?> targetClass) {
        LogOperationCacheKey cacheKey = new LogOperationCacheKey(operation, method, targetClass);
        LogOperationMetadata metadata = this.metadataCache.get(cacheKey);
        if (metadata == null) {
            HashMap<String, Expression> variableExpressionMap = new HashMap<String, Expression>();
            for (String template : operation.before) {
                if (!StringUtils.hasText((String)template)) continue;
                int delimiterIndex = template.indexOf("=");
                String variableName = template.substring(0, delimiterIndex);
                String expressionStr = template.substring(delimiterIndex + 1);
                Expression expression = this.getExpressionParser().parseExpression(expressionStr);
                variableExpressionMap.put(variableName, expression);
            }
            HashMap<String, Expression> templateExpressionMap = new HashMap<String, Expression>();
            templateExpressionMap.put(operation.content, this.getExpressionParser().parseExpression(operation.content));
            templateExpressionMap.put(operation.fail, this.getExpressionParser().parseExpression(operation.fail));
            templateExpressionMap.put(operation.detail, this.getExpressionParser().parseExpression(operation.detail));
            templateExpressionMap.put(operation.condition, this.getExpressionParser().parseExpression(operation.condition));
            metadata = new LogOperationMetadata(operation, variableExpressionMap, templateExpressionMap);
            this.metadataCache.put(cacheKey, metadata);
        }
        return metadata;
    }

    public OperatorService getOperatorService() {
        return this.operatorService;
    }

    public void setOperatorService(OperatorService operatorService) {
        this.operatorService = operatorService;
    }

    public void setOperationLogRecorder(OperationLogRecorder operationLogRecorder) {
        this.operationLogRecorder = operationLogRecorder;
    }

    public OperationLogSource getOperationSource() {
        return this.operationSource;
    }

    public void setOperationSource(OperationLogSource operationSource) {
        this.operationSource = operationSource;
    }

    public SpelFunctionExpressionParser getExpressionParser() {
        return this.expressionParser;
    }

    public void setExpressionParser(SpelFunctionExpressionParser expressionParser) {
        this.expressionParser = expressionParser;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)((Object)this.expressionParser), (String)"expressionParser can not be empty");
        Assert.notNull((Object)this.operatorService, (String)"expressionEvaluator can not be empty");
        Assert.notNull((Object)this.operationLogRecorder, (String)"OperationLogRecorder can not be empty");
    }

    private static final class LogOperationCacheKey
    implements Comparable<LogOperationCacheKey> {
        private final OperationLogParam operation;
        private final AnnotatedElementKey methodCacheKey;

        private LogOperationCacheKey(OperationLogParam operationLogParam, Method method, Class<?> targetClass) {
            this.operation = operationLogParam;
            this.methodCacheKey = new AnnotatedElementKey((AnnotatedElement)method, targetClass);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LogOperationCacheKey)) {
                return false;
            }
            LogOperationCacheKey otherKey = (LogOperationCacheKey)other;
            return this.operation.equals(otherKey.operation) && this.methodCacheKey.equals((Object)otherKey.methodCacheKey);
        }

        public int hashCode() {
            return this.operation.hashCode() * 31 + this.methodCacheKey.hashCode();
        }

        public String toString() {
            return this.operation + " on " + this.methodCacheKey;
        }

        @Override
        public int compareTo(LogOperationCacheKey other) {
            int result = this.operation.getName().compareTo(other.operation.getName());
            if (result == 0) {
                result = this.methodCacheKey.compareTo(other.methodCacheKey);
            }
            return result;
        }
    }

    protected static class LogOperationMetadata {
        private final OperationLogParam operation;
        private final Map<String, Expression> variableExpressionMap;
        private final Map<String, Expression> templateExpressionMap;

        public LogOperationMetadata(OperationLogParam operation, Map<String, Expression> variableExpressionMap, Map<String, Expression> templateExpressionMap) {
            this.operation = operation;
            this.variableExpressionMap = variableExpressionMap;
            this.templateExpressionMap = templateExpressionMap;
        }
    }
}

