/*
 * Decompiled with CFR 0.152.
 */
package cn.hangsman.operationlog.interceptor;

import cn.hangsman.operationlog.annotation.OperationLog;
import cn.hangsman.operationlog.interceptor.OperationLogSource;
import java.lang.reflect.Method;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.support.StaticMethodMatcherPointcut;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.CollectionUtils;

public abstract class OperationLogSourcePointcut
extends StaticMethodMatcherPointcut {
    public OperationLogSourcePointcut() {
        this.setClassFilter(new OperationLogClassFilter());
    }

    public boolean matches(Method method, Class<?> targetClass) {
        OperationLogSource operationSource = this.getLogOperationSource();
        return operationSource != null && !CollectionUtils.isEmpty(operationSource.getLogOperations(method, targetClass));
    }

    protected abstract OperationLogSource getLogOperationSource();

    private static class OperationLogClassFilter
    implements ClassFilter {
        private OperationLogClassFilter() {
        }

        public boolean matches(Class<?> clazz) {
            return AnnotationUtils.isCandidateClass(clazz, OperationLog.class);
        }
    }
}

