/*
 * Decompiled with CFR 0.152.
 */
package cn.hangsman.operationlog.spel;

import cn.hangsman.operationlog.spel.FunctionExpression;
import cn.hangsman.operationlog.spel.FunctionExpressionProxy;
import cn.hangsman.operationlog.spel.SpelFunction;
import cn.hangsman.operationlog.spel.SpelFunctionFactory;
import cn.hangsman.operationlog.spel.SpelUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.context.expression.MethodBasedEvaluationContext;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParseException;
import org.springframework.expression.ParserContext;
import org.springframework.expression.TypedValue;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.expression.common.TemplateAwareExpressionParser;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class SpelFunctionExpressionParser
extends TemplateAwareExpressionParser
implements SmartInitializingSingleton,
BeanFactoryAware {
    private static final Logger log = LoggerFactory.getLogger(SpelFunctionExpressionParser.class);
    private static final String FUNCTION_VARIABLE_PREFIX = "$";
    private final LiteralExpression EMPTY_EXPRESSION = new LiteralExpression("");
    private final ParserContext functionParserContext = new TemplateParserContext("(", ")");
    private final ParserContext templateParserContext = new TemplateParserContext("{", "}");
    private final SpelExpressionParser spelExpressionParser = new SpelExpressionParser();
    private final ParameterNameDiscoverer parameterNameDiscoverer = new DefaultParameterNameDiscoverer();
    private SpelFunctionFactory functionFactory;
    private BeanFactory beanFactory;

    public EvaluationContext createEvaluationContext(Method method, Object[] arguments) {
        MethodBasedEvaluationContext evaluationContext = new MethodBasedEvaluationContext((Object)TypedValue.NULL, method, arguments, this.parameterNameDiscoverer);
        if (this.beanFactory != null) {
            evaluationContext.setBeanResolver((BeanResolver)new BeanFactoryResolver(this.beanFactory));
        }
        return evaluationContext;
    }

    public Expression parseExpression(String expressionString) throws ParseException {
        if (!StringUtils.hasText((String)expressionString)) {
            return this.EMPTY_EXPRESSION;
        }
        try {
            return this.parseExpression(expressionString, this.templateParserContext);
        }
        catch (Exception e) {
            log.error("parse expression error : {}", (Object)expressionString);
            throw e;
        }
    }

    protected Expression doParseExpression(String expressionString, ParserContext context) throws ParseException {
        if (expressionString.contains(FUNCTION_VARIABLE_PREFIX)) {
            return this.doParseFunctionExpression(expressionString, this.functionParserContext);
        }
        return this.spelExpressionParser.parseExpression(expressionString);
    }

    private Expression doParseFunctionExpression(String expressionString, ParserContext context) {
        int $Index;
        int prefixIndex;
        String prefix = context.getExpressionPrefix();
        String suffix = context.getExpressionSuffix();
        HashMap<String, Expression> variableExpressionMap = new HashMap<String, Expression>();
        int startIdx = 0;
        while (startIdx < expressionString.length() && (prefixIndex = expressionString.indexOf(prefix, $Index = expressionString.indexOf(FUNCTION_VARIABLE_PREFIX, startIdx))) >= startIdx) {
            String functionName = expressionString.substring($Index + FUNCTION_VARIABLE_PREFIX.length(), prefixIndex);
            Assert.hasLength((String)functionName, (String)("functionName can not be empty:" + expressionString));
            int afterPrefixIndex = prefixIndex + prefix.length();
            int suffixIndex = SpelUtil.skipToCorrectEndSuffix(suffix, expressionString, afterPrefixIndex);
            if (suffixIndex == -1) {
                throw new ParseException(expressionString, prefixIndex, "No ending suffix '" + suffix + "' for expression starting at character " + prefixIndex + ": " + expressionString.substring(prefixIndex));
            }
            if (suffixIndex == afterPrefixIndex) {
                throw new ParseException(expressionString, prefixIndex, "No expression defined within delimiter '" + prefix + suffix + "' at character " + prefixIndex);
            }
            String expr = expressionString.substring(prefixIndex + prefix.length(), suffixIndex);
            if (expr.isEmpty()) {
                throw new ParseException(expressionString, prefixIndex, "No expression defined within delimiter '" + prefix + suffix + "' at character " + prefixIndex);
            }
            ArrayList<Expression> expressions = new ArrayList<Expression>();
            for (String spel : expr.split(",")) {
                expressions.add(this.doParseExpression(spel, null));
            }
            String expressionStr = FUNCTION_VARIABLE_PREFIX + functionName + prefix + expr + suffix;
            SpelFunction function = this.functionFactory.getFunction(functionName);
            Assert.notNull((Object)function, (String)("could not find function :" + functionName));
            FunctionExpression functionExpression = new FunctionExpression(expressionStr, expressions.toArray(new Expression[0]), function);
            String variableId = UUID.randomUUID().toString().replace("-", "");
            variableExpressionMap.put("function_" + variableId, functionExpression);
            startIdx = suffixIndex + suffix.length();
        }
        String originExpressionString = expressionString;
        for (String key : variableExpressionMap.keySet()) {
            Expression expression = (Expression)variableExpressionMap.get(key);
            expressionString = expressionString.replace(expression.getExpressionString(), "#" + key);
        }
        Expression proxyExpression = this.doParseExpression(expressionString, null);
        return new FunctionExpressionProxy(originExpressionString, proxyExpression, variableExpressionMap);
    }

    public void afterSingletonsInstantiated() {
        try {
            this.setFunctionFactory((SpelFunctionFactory)this.beanFactory.getBean(SpelFunctionFactory.class));
        }
        catch (NoUniqueBeanDefinitionException ex) {
            throw new IllegalStateException("no unique bean of type SpelFunctionFactory found. Mark one as primary or declare a specific SpelFunctionFactory to use.", ex);
        }
        catch (NoSuchBeanDefinitionException ex) {
            throw new IllegalStateException("no bean of type SpelFunctionFactory found. Register a SpelFunctionFactory bean or remove the @EnableOperationLog annotation from your configuration.", ex);
        }
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setFunctionFactory(SpelFunctionFactory functionFactory) {
        this.functionFactory = functionFactory;
    }
}

