/*
 * Decompiled with CFR 0.152.
 */
package cn.hangsman.operationlog.spel;

import cn.hangsman.operationlog.spel.SpelFunction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class SpelFunctionFactory {
    private final Map<String, SpelFunction> functionMap = new HashMap<String, SpelFunction>();

    public SpelFunctionFactory(List<SpelFunction> functions) {
        if (!CollectionUtils.isEmpty(functions)) {
            for (SpelFunction parseFunction : functions) {
                String functionName = parseFunction.functionName();
                Assert.hasLength((String)functionName, (String)"functionName can not be empty\uff01");
                this.functionMap.put(functionName, parseFunction);
            }
        }
    }

    public SpelFunction getFunction(String functionName) {
        return this.functionMap.get(functionName);
    }
}

