/*
 * Decompiled with CFR 0.152.
 */
package cn.hangsman.operationlog.spel;

import java.util.ArrayDeque;
import org.springframework.expression.ParseException;

public class SpelUtil {
    private static boolean isSuffixHere(String expressionString, int pos, String suffix) {
        int suffixPosition = 0;
        for (int i = 0; i < suffix.length() && pos < expressionString.length(); ++i) {
            if (expressionString.charAt(pos++) == suffix.charAt(suffixPosition++)) continue;
            return false;
        }
        return suffixPosition == suffix.length();
    }

    public static int skipToCorrectEndSuffix(String suffix, String expressionString, int afterPrefixIndex) throws ParseException {
        int pos;
        int maxlen = expressionString.length();
        int nextSuffix = expressionString.indexOf(suffix, afterPrefixIndex);
        if (nextSuffix == -1) {
            return -1;
        }
        ArrayDeque<Bracket> stack = new ArrayDeque<Bracket>();
        block5: for (pos = afterPrefixIndex; !(pos >= maxlen || SpelUtil.isSuffixHere(expressionString, pos, suffix) && stack.isEmpty()); ++pos) {
            char ch = expressionString.charAt(pos);
            switch (ch) {
                case '(': 
                case '[': 
                case '{': {
                    stack.push(new Bracket(ch, pos));
                    continue block5;
                }
                case ')': 
                case ']': 
                case '}': {
                    if (stack.isEmpty()) {
                        throw new ParseException(expressionString, pos, "Found closing '" + ch + "' at position " + pos + " without an opening '" + Bracket.theOpenBracketFor(ch) + "'");
                    }
                    Bracket p = (Bracket)stack.pop();
                    if (p.compatibleWithCloseBracket(ch)) continue block5;
                    throw new ParseException(expressionString, pos, "Found closing '" + ch + "' at position " + pos + " but most recent opening is '" + p.bracket + "' at position " + p.pos);
                }
                case '\"': 
                case '\'': {
                    int endLiteral = expressionString.indexOf(ch, pos + 1);
                    if (endLiteral == -1) {
                        throw new ParseException(expressionString, pos, "Found non terminating string literal starting at position " + pos);
                    }
                    pos = endLiteral;
                }
            }
        }
        if (!stack.isEmpty()) {
            Bracket p = (Bracket)stack.pop();
            throw new ParseException(expressionString, p.pos, "Missing closing '" + Bracket.theCloseBracketFor(p.bracket) + "' for '" + p.bracket + "' at position " + p.pos);
        }
        if (!SpelUtil.isSuffixHere(expressionString, pos, suffix)) {
            return -1;
        }
        return pos;
    }

    private static class Bracket {
        char bracket;
        int pos;

        Bracket(char bracket, int pos) {
            this.bracket = bracket;
            this.pos = pos;
        }

        static char theOpenBracketFor(char closeBracket) {
            if (closeBracket == '}') {
                return '{';
            }
            if (closeBracket == ']') {
                return '[';
            }
            return '(';
        }

        static char theCloseBracketFor(char openBracket) {
            if (openBracket == '{') {
                return '}';
            }
            if (openBracket == '[') {
                return ']';
            }
            return ')';
        }

        boolean compatibleWithCloseBracket(char closeBracket) {
            if (this.bracket == '{') {
                return closeBracket == '}';
            }
            if (this.bracket == '[') {
                return closeBracket == ']';
            }
            return closeBracket == ')';
        }
    }
}

