/*
 * Decompiled with CFR 0.152.
 */
package cn.hchub.groovy.controller;

import cn.hchub.groovy.GroovyBaseDTO;
import cn.hchub.groovy.GroovyScriptBeanReader;
import cn.hchub.groovy.controller.GroovyBeansResponseDTO;
import cn.hchub.groovy.controller.GroovyDestroyBeanRequestDTO;
import cn.hchub.groovy.engine.GroovyObjMapping;
import cn.hchub.groovy.engine.GroovyParser;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/groovy/script/api"})
public class GroovyApiController {
    @Autowired
    private GroovyScriptBeanReader groovyScriptBeanReader;

    @ResponseBody
    @PostMapping(value={"/get/beans"}, produces={"application/json;charset=UTF-8"})
    public GroovyBeansResponseDTO getBeans(@Valid @RequestBody GroovyBaseDTO requestDTO) {
        Set parserBeans = this.groovyScriptBeanReader.getBeans(GroovyParser.class);
        Set objMappingBeans = this.groovyScriptBeanReader.getBeans(GroovyObjMapping.class);
        GroovyBeansResponseDTO responseDTO = new GroovyBeansResponseDTO();
        responseDTO.setBeans(Stream.of(parserBeans, objMappingBeans).flatMap(Collection::stream).collect(Collectors.toSet()));
        return responseDTO;
    }

    @ResponseBody
    @PostMapping(value={"/bean/unload"}, produces={"application/json;charset=UTF-8"})
    public GroovyBaseDTO unloadBean(@Valid @RequestBody GroovyDestroyBeanRequestDTO requestDTO) {
        Set beanNames = requestDTO.getBeans().stream().map(bean -> bean.getBeanName()).collect(Collectors.toSet());
        this.groovyScriptBeanReader.destroyBeanDefinition(beanNames);
        GroovyBaseDTO responseDTO = new GroovyBaseDTO();
        return responseDTO;
    }
}

