/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.access.wxapp.configuration;

import cn.herodotus.engine.access.wxapp.annotation.ConditionalOnWxappEnabled;
import cn.herodotus.engine.access.wxapp.processor.WxappAccessHandler;
import cn.herodotus.engine.access.wxapp.processor.WxappLogHandler;
import cn.herodotus.engine.access.wxapp.processor.WxappProcessor;
import cn.herodotus.engine.access.wxapp.properties.WxappProperties;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnWxappEnabled
@EnableConfigurationProperties(value={WxappProperties.class})
public class AccessWxappConfiguration {
    private static final Logger log = LoggerFactory.getLogger(AccessWxappConfiguration.class);

    @PostConstruct
    public void init() {
        log.debug("[Herodotus] |- SDK [Access Wxapp] Auto Configure.");
    }

    @Bean
    @ConditionalOnMissingBean
    public WxappProcessor wxappProcessor(WxappProperties wxappProperties) {
        WxappProcessor wxappProcessor = new WxappProcessor();
        wxappProcessor.setWxappProperties(wxappProperties);
        wxappProcessor.setWxappLogHandler(new WxappLogHandler());
        log.trace("[Herodotus] |- Bean [Wxapp Processor] Auto Configure.");
        return wxappProcessor;
    }

    @Bean(value={"WECHAT_MINI_APP"})
    @ConditionalOnBean(value={WxappProcessor.class})
    @ConditionalOnMissingBean
    public WxappAccessHandler wxappAccessHandler(WxappProcessor wxappProcessor) {
        WxappAccessHandler wxappAccessHandler = new WxappAccessHandler(wxappProcessor);
        log.debug("[Herodotus] |- Bean [Wxapp Access Handler] Auto Configure.");
        return wxappAccessHandler;
    }
}

