/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.cache.jetcache.enhance;

import cn.hutool.crypto.SecureUtil;
import com.alibaba.fastjson2.JSON;
import com.alicp.jetcache.Cache;
import com.alicp.jetcache.CacheManager;
import com.alicp.jetcache.anno.CacheType;
import com.alicp.jetcache.template.QuickConfig;
import java.time.Duration;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class JetCacheCreateCacheFactory {
    private final CacheManager cacheManager;

    public JetCacheCreateCacheFactory(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public <K, V> Cache<K, V> create(String name) {
        return this.create(name, Duration.ofHours(2L));
    }

    public <K, V> Cache<K, V> create(String name, Duration expire) {
        return this.create(name, expire, true);
    }

    public <K, V> Cache<K, V> create(String name, Duration expire, Boolean cacheNullValue) {
        return this.create(name, expire, cacheNullValue, null);
    }

    public <K, V> Cache<K, V> create(String name, Duration expire, Boolean cacheNullValue, Boolean syncLocal) {
        return this.create(name, CacheType.BOTH, expire, cacheNullValue, syncLocal);
    }

    public <K, V> Cache<K, V> create(String name, CacheType cacheType) {
        return this.create(name, cacheType, null);
    }

    public <K, V> Cache<K, V> create(String name, CacheType cacheType, Duration expire) {
        return this.create(name, cacheType, expire, (Boolean)true);
    }

    public <K, V> Cache<K, V> create(String name, CacheType cacheType, Duration expire, Boolean cacheNullValue) {
        return this.create(name, cacheType, expire, cacheNullValue, null);
    }

    public <K, V> Cache<K, V> create(String name, CacheType cacheType, Duration expire, Boolean cacheNullValue, Boolean syncLocal) {
        return this.create(null, name, cacheType, expire, cacheNullValue, syncLocal);
    }

    public <K, V> Cache<K, V> create(String area, String name, CacheType cacheType, Duration expire, Boolean cacheNullValue, Boolean syncLocal) {
        return this.create(area, name, cacheType, expire, cacheNullValue, syncLocal, null);
    }

    public <K, V> Cache<K, V> create(String area, String name, CacheType cacheType, Duration expire, Boolean cacheNullValue, Boolean syncLocal, Duration localExpire) {
        return this.create(area, name, cacheType, expire, cacheNullValue, syncLocal, localExpire, null);
    }

    public <K, V> Cache<K, V> create(String area, String name, CacheType cacheType, Duration expire, Boolean cacheNullValue, Boolean syncLocal, Duration localExpire, Integer localLimit) {
        return this.create(area, name, cacheType, expire, cacheNullValue, syncLocal, localExpire, localLimit, false);
    }

    public <K, V> Cache<K, V> create(String area, String name, CacheType cacheType, Duration expire, Boolean cacheNullValue, Boolean syncLocal, Duration localExpire, Integer localLimit, Boolean useAreaInPrefix) {
        return this.create(area, name, cacheType, expire, cacheNullValue, syncLocal, localExpire, localLimit, useAreaInPrefix, false, null);
    }

    public <K, V> Cache<K, V> create(String area, String name, CacheType cacheType, Duration expire, Boolean cacheNullValue, Boolean syncLocal, Duration localExpire, Integer localLimit, Boolean useAreaInPrefix, Boolean penetrationProtect, Duration penetrationProtectTimeout) {
        QuickConfig.Builder builder = StringUtils.isEmpty((CharSequence)area) ? QuickConfig.newBuilder((String)name) : QuickConfig.newBuilder((String)area, (String)name);
        builder.cacheType(cacheType);
        builder.expire(expire);
        if (cacheType == CacheType.BOTH) {
            builder.syncLocal(syncLocal);
        }
        builder.localExpire(localExpire);
        builder.localLimit(localLimit);
        builder.cacheNullValue(cacheNullValue);
        builder.useAreaInPrefix(useAreaInPrefix);
        if (ObjectUtils.isNotEmpty((Object)penetrationProtect)) {
            builder.penetrationProtect(penetrationProtect);
            if (BooleanUtils.isTrue((Boolean)penetrationProtect) && ObjectUtils.isNotEmpty((Object)penetrationProtectTimeout)) {
                builder.penetrationProtectTimeout(penetrationProtectTimeout);
            }
        }
        builder.keyConvertor(key -> {
            if (key instanceof String) {
                return key;
            }
            return SecureUtil.md5((String)JSON.toJSONString((Object)key));
        });
        QuickConfig quickConfig = builder.build();
        return this.create(quickConfig);
    }

    private <K, V> Cache<K, V> create(QuickConfig quickConfig) {
        return this.cacheManager.getOrCreateCache(quickConfig);
    }
}

