/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.cache.jetcache.enhance;

import cn.herodotus.engine.cache.jetcache.enhance.JetCacheCreateCacheFactory;
import cn.herodotus.engine.cache.jetcache.enhance.JetCacheSpringCache;
import com.alicp.jetcache.Cache;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.CacheManager;
import org.springframework.lang.Nullable;

public class JetCacheSpringCacheManager
implements CacheManager {
    private static final Logger log = LoggerFactory.getLogger(JetCacheSpringCacheManager.class);
    private boolean dynamic = true;
    private boolean allowNullValues = true;
    private final Map<String, org.springframework.cache.Cache> cacheMap = new ConcurrentHashMap<String, org.springframework.cache.Cache>(16);
    private final JetCacheCreateCacheFactory jetCacheCreateCacheFactory;

    public JetCacheSpringCacheManager(JetCacheCreateCacheFactory jetCacheCreateCacheFactory) {
        this.jetCacheCreateCacheFactory = jetCacheCreateCacheFactory;
    }

    public JetCacheSpringCacheManager(JetCacheCreateCacheFactory jetCacheCreateCacheFactory, String ... cacheNames) {
        this.jetCacheCreateCacheFactory = jetCacheCreateCacheFactory;
        this.setCacheNames(Arrays.asList(cacheNames));
    }

    public void setAllowNullValues(boolean allowNullValues) {
        this.allowNullValues = allowNullValues;
    }

    public boolean isAllowNullValues() {
        return this.allowNullValues;
    }

    private void setCacheNames(@Nullable Collection<String> cacheNames) {
        if (cacheNames != null) {
            for (String name : cacheNames) {
                this.cacheMap.put(name, this.createJetCache(name));
            }
            this.dynamic = false;
        } else {
            this.dynamic = true;
        }
    }

    protected org.springframework.cache.Cache createJetCache(String name) {
        Cache cache = this.jetCacheCreateCacheFactory.create(name);
        log.debug("[Herodotus] |- CACHE - Herodotus cache [{}] is CREATED.", (Object)name);
        return new JetCacheSpringCache(name, cache, this.allowNullValues);
    }

    protected org.springframework.cache.Cache createJetCache(String name, Duration expire) {
        Cache cache = this.jetCacheCreateCacheFactory.create(name, expire, this.allowNullValues, (Boolean)true);
        log.debug("[Herodotus] |- CACHE - Herodotus cache [{}] with expire is CREATED.", (Object)name);
        return new JetCacheSpringCache(name, cache, this.allowNullValues);
    }

    private String availableCacheName(String name) {
        if (StringUtils.endsWith((CharSequence)name, (CharSequence)":")) {
            return name;
        }
        return name + ":";
    }

    @Nullable
    public org.springframework.cache.Cache getCache(String name) {
        String usedName = this.availableCacheName(name);
        return this.cacheMap.computeIfAbsent(usedName, cacheName -> this.dynamic ? this.createJetCache((String)cacheName) : null);
    }

    public Collection<String> getCacheNames() {
        return Collections.unmodifiableSet(this.cacheMap.keySet());
    }
}

