/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.cache.jetcache.enhance;

import cn.herodotus.engine.cache.core.properties.CacheProperties;
import cn.herodotus.engine.cache.core.properties.CacheSetting;
import cn.herodotus.engine.cache.jetcache.enhance.JetCacheCreateCacheFactory;
import cn.herodotus.engine.cache.jetcache.enhance.JetCacheSpringCacheManager;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;

public class HerodotusCacheManager
extends JetCacheSpringCacheManager {
    private static final Logger log = LoggerFactory.getLogger(HerodotusCacheManager.class);
    private final CacheProperties cacheProperties;

    public HerodotusCacheManager(JetCacheCreateCacheFactory jetCacheCreateCacheFactory, CacheProperties cacheProperties) {
        super(jetCacheCreateCacheFactory);
        this.cacheProperties = cacheProperties;
        this.setAllowNullValues(cacheProperties.getAllowNullValues());
    }

    public HerodotusCacheManager(JetCacheCreateCacheFactory jetCacheCreateCacheFactory, CacheProperties cacheProperties, String ... cacheNames) {
        super(jetCacheCreateCacheFactory, cacheNames);
        this.cacheProperties = cacheProperties;
    }

    @Override
    protected Cache createJetCache(String name) {
        String key;
        Map instances = this.cacheProperties.getInstances();
        if (MapUtils.isNotEmpty((Map)instances) && instances.containsKey(key = StringUtils.replace((String)name, (String)":", (String)this.cacheProperties.getSeparator()))) {
            CacheSetting cacheSetting = (CacheSetting)instances.get(key);
            log.debug("[Herodotus] |- CACHE - Cache [{}] is set to use INSTANCE cache.", (Object)name);
            return super.createJetCache(name, cacheSetting);
        }
        return super.createJetCache(name);
    }
}

