/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.cache.jetcache.enhance;

import cn.herodotus.engine.assistant.core.json.jackson2.utils.Jackson2Utils;
import com.alicp.jetcache.Cache;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.support.AbstractValueAdaptingCache;
import org.springframework.lang.Nullable;

public class JetCacheSpringCache
extends AbstractValueAdaptingCache {
    private static final Logger log = LoggerFactory.getLogger(JetCacheSpringCache.class);
    private final String cacheName;
    private final Cache<Object, Object> cache;

    public JetCacheSpringCache(String cacheName, Cache<Object, Object> cache, boolean allowNullValues) {
        super(allowNullValues);
        this.cacheName = cacheName;
        this.cache = cache;
    }

    public String getName() {
        return this.cacheName;
    }

    public final Cache<Object, Object> getNativeCache() {
        return this.cache;
    }

    @Nullable
    protected Object lookup(Object key) {
        Object value = this.cache.get(key);
        if (ObjectUtils.isNotEmpty((Object)value)) {
            log.trace("[Herodotus] |- CACHE - Lookup data in herodotus cache, value is : [{}]", (Object)Jackson2Utils.toJson((Object)value));
            return value;
        }
        return null;
    }

    @Nullable
    public <T> T get(Object key, Callable<T> valueLoader) {
        log.trace("[Herodotus] |- CACHE - Get data in herodotus cache, key: {}", key);
        return (T)this.fromStoreValue(this.cache.computeIfAbsent(key, k -> {
            try {
                return this.toStoreValue(valueLoader.call());
            }
            catch (Throwable ex) {
                throw new Cache.ValueRetrievalException(key, valueLoader, ex);
            }
        }));
    }

    @Nullable
    public void put(Object key, @Nullable Object value) {
        log.trace("[Herodotus] |- CACHE - Put data in herodotus cache, key: {}", key);
        this.cache.put(key, this.toStoreValue(value));
    }

    @Nullable
    public Cache.ValueWrapper putIfAbsent(Object key, @Nullable Object value) {
        log.trace("[Herodotus] |- CACHE - PutIfPresent data in herodotus cache, key: {}", key);
        Boolean existing = this.cache.putIfAbsent(key, this.toStoreValue(value));
        return this.toValueWrapper(existing);
    }

    public void evict(Object key) {
        log.trace("[Herodotus] |- CACHE - Evict data in herodotus cache, key: {}", key);
        this.cache.remove(key);
    }

    public boolean evictIfPresent(Object key) {
        log.trace("[Herodotus] |- CACHE - EvictIfPresent data in herodotus cache, key: {}", key);
        return this.cache.remove(key);
    }

    public void clear() {
        log.trace("[Herodotus] |- CACHE - Clear data in herodotus cache.");
        this.cache.close();
    }
}

