/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.cache.jetcache.stamp;

import cn.herodotus.engine.cache.core.exception.StampDeleteFailedException;
import cn.herodotus.engine.cache.core.exception.StampHasExpiredException;
import cn.herodotus.engine.cache.core.exception.StampMismatchException;
import cn.herodotus.engine.cache.core.exception.StampParameterIllegalException;
import com.alicp.jetcache.AutoReleaseLock;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.InitializingBean;

public interface StampManager<K, V>
extends InitializingBean {
    public Duration getExpire();

    public void put(K var1, V var2, long var3, TimeUnit var5);

    default public void put(K key, V value, Duration expire) {
        this.put(key, value, expire.toMillis(), TimeUnit.MILLISECONDS);
    }

    default public void put(K key, V value) {
        this.put(key, value, this.getExpire());
    }

    public V nextStamp(K var1);

    default public V create(K key, long expireAfterWrite, TimeUnit timeUnit) {
        V value = this.nextStamp(key);
        this.put(key, value, expireAfterWrite, timeUnit);
        return value;
    }

    default public V create(K key, Duration expire) {
        return this.create(key, expire.toMillis(), TimeUnit.MILLISECONDS);
    }

    default public V create(K key) {
        return this.create(key, this.getExpire());
    }

    public boolean check(K var1, V var2) throws StampParameterIllegalException, StampHasExpiredException, StampMismatchException;

    public V get(K var1);

    public void delete(K var1) throws StampDeleteFailedException;

    default public boolean containKey(K key) {
        V value = this.get(key);
        return ObjectUtils.isNotEmpty(value);
    }

    public AutoReleaseLock lock(K var1, long var2, TimeUnit var4);

    default public AutoReleaseLock lock(K key, Duration expire) {
        return this.lock(key, expire.toMillis(), TimeUnit.MILLISECONDS);
    }

    default public AutoReleaseLock lock(K key) {
        return this.lock(key, this.getExpire());
    }

    public boolean lockAndRun(K var1, long var2, TimeUnit var4, Runnable var5);

    default public boolean lockAndRun(K key, Duration expire, Runnable action) {
        return this.lockAndRun(key, expire.toMillis(), TimeUnit.MILLISECONDS, action);
    }

    default public boolean lockAndRun(K key, Runnable action) {
        return this.lockAndRun(key, this.getExpire(), action);
    }
}

