/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.cache.redis.session;

import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.session.web.http.CookieHttpSessionIdResolver;
import org.springframework.session.web.http.CookieSerializer;
import org.springframework.session.web.http.DefaultCookieSerializer;
import org.springframework.session.web.http.HttpSessionIdResolver;

public class HerodotusHttpSessionIdResolver
implements HttpSessionIdResolver {
    private static final Logger log = LoggerFactory.getLogger(HerodotusHttpSessionIdResolver.class);
    private static final String WRITTEN_SESSION_ID_ATTR = CookieHttpSessionIdResolver.class.getName().concat(".WRITTEN_SESSION_ID_ATTR");
    private final String headerName;
    private CookieSerializer cookieSerializer = new DefaultCookieSerializer();

    public HerodotusHttpSessionIdResolver(String headerName) {
        if (StringUtils.isBlank((CharSequence)headerName)) {
            throw new IllegalArgumentException("headerName cannot be null");
        }
        this.headerName = headerName;
    }

    private String resolveHeaderSessionId(HttpServletRequest request) {
        String headerValue = request.getHeader(this.headerName);
        if (StringUtils.isNotBlank((CharSequence)headerValue)) {
            log.debug("[Herodotus] |- Resolve http session id [{}] from header in request [{}]", (Object)headerValue, (Object)request.getRequestURI());
            return headerValue;
        }
        return null;
    }

    private List<String> resolveHeaderSessionIds(HttpServletRequest request) {
        String id = this.resolveHeaderSessionId(request);
        return StringUtils.isNotBlank((CharSequence)id) ? Collections.singletonList(id) : Collections.emptyList();
    }

    public List<String> resolveSessionIds(HttpServletRequest request) {
        List<String> idsInHeader = this.resolveHeaderSessionIds(request);
        if (CollectionUtils.isNotEmpty(idsInHeader)) {
            return idsInHeader;
        }
        return this.cookieSerializer.readCookieValues(request);
    }

    private void changeSessionId(HttpServletRequest request, HttpServletResponse response, String sessionId) {
        this.cookieSerializer.writeCookieValue(new CookieSerializer.CookieValue(request, response, sessionId));
        response.setHeader(this.headerName, sessionId);
    }

    public void setSessionId(HttpServletRequest request, HttpServletResponse response, String sessionId) {
        if (sessionId.equals(request.getAttribute(WRITTEN_SESSION_ID_ATTR))) {
            return;
        }
        String id = sessionId;
        String herodotusSessionId = this.resolveHeaderSessionId(request);
        if (StringUtils.isNotBlank((CharSequence)herodotusSessionId)) {
            id = herodotusSessionId;
        }
        request.setAttribute(WRITTEN_SESSION_ID_ATTR, (Object)id);
        this.changeSessionId(request, response, id);
    }

    public void expireSession(HttpServletRequest request, HttpServletResponse response) {
        this.changeSessionId(request, response, "");
    }

    public void setCookieSerializer(CookieSerializer cookieSerializer) {
        if (cookieSerializer == null) {
            throw new IllegalArgumentException("cookieSerializer cannot be null");
        }
        this.cookieSerializer = cookieSerializer;
    }
}

