/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.message.websocket.interceptor;

import cn.herodotus.engine.assistant.core.definition.BearerTokenResolver;
import cn.herodotus.engine.assistant.core.domain.PrincipalDetails;
import cn.herodotus.engine.message.websocket.utils.WebSocketUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.server.HandshakeInterceptor;

public class WebSocketAuthenticationHandshakeInterceptor
implements HandshakeInterceptor {
    private static final Logger log = LoggerFactory.getLogger(WebSocketAuthenticationHandshakeInterceptor.class);
    private static final String SEC_WEBSOCKET_PROTOCOL = "Sec-WebSocket-Protocol";
    private final BearerTokenResolver bearerTokenResolver;

    public WebSocketAuthenticationHandshakeInterceptor(BearerTokenResolver bearerTokenResolver) {
        this.bearerTokenResolver = bearerTokenResolver;
    }

    public boolean beforeHandshake(ServerHttpRequest request, ServerHttpResponse response, WebSocketHandler wsHandler, Map<String, Object> attributes) throws Exception {
        HttpServletRequest httpServletRequest = WebSocketUtils.getHttpServletRequest(request);
        if (ObjectUtils.isNotEmpty((Object)httpServletRequest)) {
            String protocol = httpServletRequest.getHeader(SEC_WEBSOCKET_PROTOCOL);
            String token = this.determineToken(protocol);
            if (StringUtils.isNotBlank((CharSequence)token)) {
                PrincipalDetails details = this.bearerTokenResolver.resolve(token);
                attributes.put("principal", details);
                log.debug("[Herodotus] |- WebSocket fetch the token is [{}].", (Object)token);
            } else {
                response.setStatusCode((HttpStatusCode)HttpStatus.UNAUTHORIZED);
                log.info("[Herodotus] |- Token is invalid for WebSocket, stop handshake.");
                return false;
            }
        }
        return true;
    }

    private String determineToken(String protocol) {
        if (StringUtils.contains((CharSequence)protocol, (CharSequence)",")) {
            String[] protocols;
            for (String item : protocols = StringUtils.split((String)protocol, (String)",")) {
                if (StringUtils.endsWith((CharSequence)item, (CharSequence)".stomp")) continue;
                return item;
            }
        }
        return null;
    }

    public void afterHandshake(ServerHttpRequest request, ServerHttpResponse response, WebSocketHandler wsHandler, Exception ex) {
        HttpServletRequest httpServletRequest = WebSocketUtils.getHttpServletRequest(request);
        HttpServletResponse httpServletResponse = WebSocketUtils.getHttpServletResponse(response);
        if (ObjectUtils.isNotEmpty((Object)httpServletRequest) && ObjectUtils.isNotEmpty((Object)httpServletResponse)) {
            httpServletResponse.setHeader(SEC_WEBSOCKET_PROTOCOL, "v10.stomp");
        }
        log.info("[Herodotus] |- WebSocket handshake success!");
    }
}

