/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.message.websocket.interceptor;

import cn.herodotus.engine.assistant.definition.domain.PrincipalDetails;
import cn.herodotus.engine.message.websocket.domain.WebSocketPrincipal;
import java.security.Principal;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.server.support.DefaultHandshakeHandler;

public class WebSocketPrincipalHandshakeHandler
extends DefaultHandshakeHandler {
    private static final Logger log = LoggerFactory.getLogger(WebSocketPrincipalHandshakeHandler.class);

    protected Principal determineUser(ServerHttpRequest request, WebSocketHandler wsHandler, Map<String, Object> attributes) {
        Object object = attributes.get("principal");
        if (ObjectUtils.isNotEmpty((Object)object) && object instanceof PrincipalDetails) {
            PrincipalDetails details = (PrincipalDetails)object;
            WebSocketPrincipal webSocketPrincipal = new WebSocketPrincipal(details);
            log.debug("[Herodotus] |- Determine user by request parameter, userId is  [{}].", (Object)webSocketPrincipal.getUserId());
            return webSocketPrincipal;
        }
        Principal principal = request.getPrincipal();
        if (ObjectUtils.isNotEmpty((Object)principal)) {
            log.debug("[Herodotus] |- Determine user from request, value is  [{}].", (Object)principal.getName());
            return principal;
        }
        log.warn("[Herodotus] |- Can not determine user from request.");
        return null;
    }
}

