/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.message.websocket.configuration;

import cn.herodotus.engine.message.websocket.interceptor.WebSocketAuthenticationHandshakeInterceptor;
import cn.herodotus.engine.message.websocket.interceptor.WebSocketChannelInterceptor;
import cn.herodotus.engine.message.websocket.interceptor.WebSocketPrincipalHandshakeHandler;
import cn.herodotus.engine.message.websocket.properties.WebSocketProperties;
import jakarta.annotation.PostConstruct;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.simp.config.ChannelRegistration;
import org.springframework.messaging.simp.config.MessageBrokerRegistry;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.session.Session;
import org.springframework.session.web.socket.config.annotation.AbstractSessionWebSocketMessageBrokerConfigurer;
import org.springframework.web.socket.config.annotation.EnableWebSocketMessageBroker;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;
import org.springframework.web.socket.config.annotation.WebSocketTransportRegistration;
import org.springframework.web.socket.server.HandshakeHandler;
import org.springframework.web.socket.server.HandshakeInterceptor;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={WebSocketProperties.class})
@EnableScheduling
@EnableWebSocketMessageBroker
public class WebSocketMessageBrokerConfiguration
extends AbstractSessionWebSocketMessageBrokerConfigurer<Session> {
    private static final Logger log = LoggerFactory.getLogger(WebSocketMessageBrokerConfiguration.class);
    private final WebSocketProperties webSocketProperties;
    private final WebSocketChannelInterceptor webSocketChannelInterceptor;
    private final WebSocketPrincipalHandshakeHandler webSocketPrincipalHandshakeHandler;
    private final WebSocketAuthenticationHandshakeInterceptor webSocketAuthenticationHandshakeInterceptor;

    public WebSocketMessageBrokerConfiguration(WebSocketProperties webSocketProperties, WebSocketAuthenticationHandshakeInterceptor webSocketAuthenticationHandshakeInterceptor) {
        this.webSocketProperties = webSocketProperties;
        this.webSocketChannelInterceptor = new WebSocketChannelInterceptor();
        this.webSocketPrincipalHandshakeHandler = new WebSocketPrincipalHandshakeHandler();
        this.webSocketAuthenticationHandshakeInterceptor = webSocketAuthenticationHandshakeInterceptor;
    }

    @PostConstruct
    public void postConstruct() {
        log.debug("[Herodotus] |- SDK [WebSocket Message Broker] Auto Configure.");
    }

    protected void configureStompEndpoints(StompEndpointRegistry registry) {
        registry.addEndpoint(new String[]{this.webSocketProperties.getEndpoint()}).setAllowedOrigins(new String[]{"*"}).addInterceptors(new HandshakeInterceptor[]{this.webSocketAuthenticationHandshakeInterceptor}).setHandshakeHandler((HandshakeHandler)this.webSocketPrincipalHandshakeHandler).withSockJS();
        registry.addEndpoint(new String[]{this.webSocketProperties.getEndpoint()}).setAllowedOrigins(new String[]{"*"}).addInterceptors(new HandshakeInterceptor[]{this.webSocketAuthenticationHandshakeInterceptor}).setHandshakeHandler((HandshakeHandler)this.webSocketPrincipalHandshakeHandler);
    }

    public void configureMessageBroker(MessageBrokerRegistry registry) {
        ThreadPoolTaskScheduler taskScheduler = new ThreadPoolTaskScheduler();
        taskScheduler.setPoolSize(1);
        taskScheduler.setThreadNamePrefix("herodotus-websocket-heartbeat-thread-");
        taskScheduler.initialize();
        registry.enableSimpleBroker(new String[]{"/broadcast", "/personal"}).setHeartbeatValue(new long[]{10000L, 10000L}).setTaskScheduler((TaskScheduler)taskScheduler);
        Object[] applicationDestinationPrefixes = this.webSocketProperties.getApplicationPrefixes();
        if (ArrayUtils.isNotEmpty((Object[])applicationDestinationPrefixes)) {
            registry.setApplicationDestinationPrefixes((String[])applicationDestinationPrefixes);
        }
        if (StringUtils.isNotBlank((CharSequence)this.webSocketProperties.getUserDestinationPrefix())) {
            registry.setUserDestinationPrefix(this.webSocketProperties.getUserDestinationPrefix());
        }
    }

    public void configureWebSocketTransport(WebSocketTransportRegistration registration) {
        registration.setMessageSizeLimit(10240).setSendBufferSizeLimit(10240).setSendTimeLimit(10000);
        super.configureWebSocketTransport(registration);
    }

    public void configureClientInboundChannel(ChannelRegistration registration) {
        registration.taskExecutor().corePoolSize(10).maxPoolSize(20).keepAliveSeconds(60);
        registration.interceptors(new ChannelInterceptor[]{this.webSocketChannelInterceptor});
        super.configureClientInboundChannel(registration);
    }

    public void configureClientOutboundChannel(ChannelRegistration registration) {
        registration.taskExecutor().corePoolSize(10).maxPoolSize(20).keepAliveSeconds(60);
    }
}

