/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.message.websocket.interceptor;

import cn.herodotus.engine.message.websocket.domain.WebSocketPrincipal;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.simp.stomp.StompCommand;
import org.springframework.messaging.simp.stomp.StompHeaderAccessor;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.messaging.support.MessageHeaderAccessor;

public class WebSocketChannelInterceptor
implements ChannelInterceptor {
    private static final Logger log = LoggerFactory.getLogger(WebSocketChannelInterceptor.class);

    public Message<?> preSend(Message<?> message, MessageChannel channel) {
        StompHeaderAccessor accessor = (StompHeaderAccessor)MessageHeaderAccessor.getAccessor(message, StompHeaderAccessor.class);
        WebSocketPrincipal principal = (WebSocketPrincipal)accessor.getUser();
        if (ObjectUtils.isEmpty((Object)principal)) {
            log.warn("[Herodotus] |- WebSocket channel cannot fetch user principal.");
            return null;
        }
        StompCommand command = accessor.getCommand();
        if (ObjectUtils.isNotEmpty((Object)command)) {
            switch (command) {
                case CONNECT: {
                    String temp;
                    List tokenHeaders = accessor.getNativeHeader("Authorization");
                    String token = null;
                    if (CollectionUtils.isNotEmpty((Collection)tokenHeaders) && StringUtils.isNotBlank((CharSequence)(temp = (String)tokenHeaders.get(0))) && StringUtils.startsWith((CharSequence)temp, (CharSequence)"Bearer ")) {
                        token = StringUtils.removeStartIgnoreCase((String)temp, (String)"Bearer ");
                    }
                    WebSocketPrincipal user = (WebSocketPrincipal)accessor.getUser();
                    log.debug("[Herodotus] |- Authentication user [{}] transmit token [{}] from frontend.", (Object)user.getName(), token);
                    break;
                }
                case DISCONNECT: {
                    break;
                }
            }
        }
        return message;
    }

    public void postSend(Message<?> message, MessageChannel channel, boolean sent) {
    }

    public void afterSendCompletion(Message<?> message, MessageChannel channel, boolean sent, Exception ex) {
    }

    public boolean preReceive(MessageChannel channel) {
        return true;
    }

    public Message<?> postReceive(Message<?> message, MessageChannel channel) {
        return message;
    }

    public void afterReceiveCompletion(Message<?> message, MessageChannel channel, Exception ex) {
    }
}

