/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.message.websocket.controller;

import cn.herodotus.engine.assistant.definition.domain.Result;
import cn.herodotus.engine.message.websocket.definition.WebSocketMessageSender;
import cn.herodotus.engine.message.websocket.utils.WebSocketUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/message/websocket"})
@Tags(value={@Tag(name="\u6d88\u606f\u63a5\u53e3"), @Tag(name="WebSocket\u6d88\u606f\u63a5\u53e3")})
public class WebSocketMessageController {
    private final WebSocketMessageSender webSocketMessageSender;

    public WebSocketMessageController(WebSocketMessageSender webSocketMessageSender) {
        this.webSocketMessageSender = webSocketMessageSender;
    }

    @Operation(summary="\u540e\u7aef\u53d1\u9001\u901a\u77e5", description="\u540e\u7aef\u53d1\u9001 WebSocket \u5e7f\u64ad\u901a\u77e5\u63a5\u53e3", requestBody=@io.swagger.v3.oas.annotations.parameters.RequestBody(content={@Content(mediaType="application/json")}), responses={@ApiResponse(description="\u662f\u5426\u6210\u529f", content={@Content(mediaType="application/json")})})
    @Parameters(value={@Parameter(name="message", required=true, description="\u6d88\u606f\u5b9e\u4f53")})
    @PostMapping(value={"/send/notice"})
    public Result<String> sendNotice(@RequestBody String message) {
        if (StringUtils.isNotBlank((CharSequence)message)) {
            this.webSocketMessageSender.announcement(message);
        }
        return Result.success((String)message);
    }

    @Operation(summary="\u83b7\u53d6\u7edf\u8ba1\u4fe1\u606f", description="\u83b7\u53d6WebSocket\u76f8\u5173\u7684\u7edf\u8ba1\u4fe1\u606f")
    @GetMapping(value={"/stat"})
    public Result<Map<String, Object>> findAllStat() {
        HashMap<String, Integer> stat = new HashMap<String, Integer>();
        stat.put("onlineCount", WebSocketUtils.getOnlineCount());
        return Result.success((String)"\u83b7\u53d6\u7edf\u8ba1\u4fe1\u606f\u6210\u529f", stat);
    }
}

