/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.message.websocket.controller;

import cn.herodotus.engine.message.core.definition.domain.WebSocketMessage;
import cn.herodotus.engine.message.core.logic.domain.DialogueMessage;
import cn.herodotus.engine.message.core.logic.event.SendDialogueMessageEvent;
import cn.herodotus.engine.message.websocket.definition.WebSocketMessageSender;
import cn.herodotus.engine.message.websocket.domain.WebSocketPrincipal;
import cn.herodotus.engine.rest.core.definition.context.AbstractApplicationContextAware;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.messaging.handler.annotation.SendTo;
import org.springframework.messaging.simp.stomp.StompHeaderAccessor;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class WebSocketPublishMessageController
extends AbstractApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(WebSocketPublishMessageController.class);
    private final WebSocketMessageSender webSocketMessageSender;

    public WebSocketPublishMessageController(WebSocketMessageSender webSocketMessageSender) {
        this.webSocketMessageSender = webSocketMessageSender;
    }

    @MessageMapping(value={"/public/notice"})
    @SendTo(value={"/broadcast/notice"})
    public String notice(String message, StompHeaderAccessor headerAccessor) {
        System.out.println("---message---" + message);
        if (ObjectUtils.isNotEmpty((Object)headerAccessor)) {
            System.out.println("---id---" + headerAccessor.getUser().getName());
        }
        return message;
    }

    @MessageMapping(value={"/private/message"})
    public void sendPrivateMessage(@Payload DialogueMessage detail, StompHeaderAccessor headerAccessor) {
        WebSocketMessage response = new WebSocketMessage();
        response.setUser(detail.getReceiverId());
        response.setDestination("/personal/message");
        if (StringUtils.isNotBlank((CharSequence)detail.getReceiverId()) && StringUtils.isNotBlank((CharSequence)detail.getReceiverName())) {
            if (StringUtils.isBlank((CharSequence)detail.getSenderId()) && StringUtils.isBlank((CharSequence)detail.getSenderName())) {
                WebSocketPrincipal sender = (WebSocketPrincipal)headerAccessor.getUser();
                detail.setSenderId(sender.getUserId());
                detail.setSenderName(sender.getUsername());
                detail.setSenderAvatar(sender.getAvatar());
            }
            this.publishEvent((ApplicationEvent)new SendDialogueMessageEvent(detail));
            response.setPayload((Object)"\u79c1\u4fe1\u53d1\u9001\u6210\u529f");
        } else {
            response.setPayload((Object)"\u79c1\u4fe1\u53d1\u9001\u5931\u8d25\uff0c\u53c2\u6570\u9519\u8bef");
        }
        this.webSocketMessageSender.toUser(response);
    }
}

