/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.message.websocket.properties;

import cn.herodotus.engine.message.websocket.enums.InstanceMode;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="herodotus.message.websocket")
public class WebSocketProperties {
    private InstanceMode mode = InstanceMode.SINGLE;
    private String endpoint = "stomp/ws";
    private List<String> applicationDestinationPrefixes = Collections.singletonList("/app");
    private String userDestinationPrefix = "/user";
    private String topic = "ws";
    private String principalHeader = "X-Herodotus-Open-Id";

    public InstanceMode getMode() {
        return this.mode;
    }

    public void setMode(InstanceMode mode) {
        this.mode = mode;
    }

    private String format(String endpoint) {
        if (StringUtils.isNotBlank((CharSequence)endpoint) && !StringUtils.startsWith((CharSequence)endpoint, (CharSequence)"/")) {
            return "/" + endpoint;
        }
        return endpoint;
    }

    public String getEndpoint() {
        return this.format(this.endpoint);
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public List<String> getApplicationDestinationPrefixes() {
        return this.applicationDestinationPrefixes;
    }

    public void setApplicationDestinationPrefixes(List<String> applicationDestinationPrefixes) {
        this.applicationDestinationPrefixes = applicationDestinationPrefixes;
    }

    public String[] getApplicationPrefixes() {
        List<String> prefixes = this.getApplicationDestinationPrefixes();
        if (CollectionUtils.isNotEmpty(prefixes)) {
            List<String> wellFormed = prefixes.stream().map(this::format).toList();
            String[] result = new String[wellFormed.size()];
            return wellFormed.toArray(result);
        }
        return new String[0];
    }

    public String getUserDestinationPrefix() {
        return this.format(this.userDestinationPrefix);
    }

    public void setUserDestinationPrefix(String userDestinationPrefix) {
        this.userDestinationPrefix = userDestinationPrefix;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getPrincipalHeader() {
        return this.principalHeader;
    }

    public void setPrincipalHeader(String principalHeader) {
        this.principalHeader = principalHeader;
    }
}

