/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.server.authorization.controller;

import cn.herodotus.engine.assistant.core.domain.Result;
import cn.herodotus.engine.assistant.core.domain.SecretKey;
import cn.herodotus.engine.oauth2.server.authorization.dto.Session;
import cn.herodotus.engine.oauth2.server.authorization.dto.SessionCreate;
import cn.herodotus.engine.oauth2.server.authorization.dto.SessionExchange;
import cn.herodotus.engine.oauth2.server.authorization.service.InterfaceSecurityService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tags(value={@Tag(name="OAuth2 \u8ba4\u8bc1\u670d\u52a1\u5668\u63a5\u53e3"), @Tag(name="OAuth2 \u8ba4\u8bc1\u670d\u52a1\u5668\u5f00\u653e\u63a5\u53e3"), @Tag(name="OAuth2 \u8eab\u4efd\u8ba4\u8bc1\u8f85\u52a9\u63a5\u53e3")})
public class IdentityController {
    private final Logger log = LoggerFactory.getLogger(IdentityController.class);
    @Autowired
    private InterfaceSecurityService interfaceSecurityService;

    @Operation(summary="\u83b7\u53d6\u540e\u53f0\u52a0\u5bc6\u516c\u94a5", description="\u6839\u636e\u672a\u767b\u5f55\u65f6\u7684\u8eab\u4efd\u6807\u8bc6\uff0c\u5728\u540e\u53f0\u521b\u5efaRSA\u516c\u94a5\u548c\u79c1\u94a5\u3002\u8eab\u4efd\u6807\u8bc6\u4e3a\u524d\u7aef\u7684\u552f\u4e00\u6807\u8bc6\uff0c\u5982\u679c\u4e3a\u7a7a\uff0c\u5219\u5728\u540e\u53f0\u521b\u5efa\u4e00\u4e2a", requestBody=@io.swagger.v3.oas.annotations.parameters.RequestBody(content={@Content(mediaType="application/json")}), responses={@ApiResponse(description="\u81ea\u5b9a\u4e49Session", content={@Content(mediaType="application/json")})})
    @Parameters(value={@Parameter(name="sessionCreate", required=true, description="Session\u521b\u5efa\u8bf7\u6c42\u53c2\u6570", schema=@Schema(implementation=SessionCreate.class))})
    @PostMapping(value={"/open/identity/session"})
    public Result<Session> codeToSession(@Validated @RequestBody SessionCreate sessionCreate) {
        SecretKey secretKey = this.interfaceSecurityService.createSecretKey(sessionCreate.getClientId(), sessionCreate.getClientSecret(), sessionCreate.getSessionId());
        if (ObjectUtils.isNotEmpty((Object)secretKey)) {
            Session session = new Session();
            session.setSessionId(secretKey.getIdentity());
            session.setPublicKey(secretKey.getPublicKey());
            return Result.content((Object)((Object)session));
        }
        return Result.failure();
    }

    @Operation(summary="\u83b7\u53d6AES\u79d8\u94a5", description="\u7528\u540e\u53f0publicKey\uff0c\u52a0\u5bc6\u524d\u53f0publicKey\uff0c\u5230\u540e\u53f0\u6362\u53d6AES\u79d8\u94a5", requestBody=@io.swagger.v3.oas.annotations.parameters.RequestBody(content={@Content(mediaType="application/json")}), responses={@ApiResponse(description="\u52a0\u5bc6\u540e\u7684AES", content={@Content(mediaType="application/json")})})
    @Parameters(value={@Parameter(name="sessionExchange", required=true, description="\u79d8\u94a5\u4ea4\u6362", schema=@Schema(implementation=SessionExchange.class))})
    @PostMapping(value={"/open/identity/exchange"})
    public Result<String> exchange(@Validated @RequestBody SessionExchange sessionExchange) {
        String encryptedAesKey = this.interfaceSecurityService.exchange(sessionExchange.getSessionId(), sessionExchange.getConfidential());
        if (StringUtils.isNotEmpty((CharSequence)encryptedAesKey)) {
            return Result.content((Object)encryptedAesKey);
        }
        return Result.failure();
    }
}

