/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.server.authorization.controller;

import cn.herodotus.engine.assistant.core.definition.domain.Entity;
import cn.herodotus.engine.assistant.core.domain.Result;
import cn.herodotus.engine.data.core.service.WriteableService;
import cn.herodotus.engine.oauth2.server.authorization.dto.OAuth2AuthorityDto;
import cn.herodotus.engine.oauth2.server.authorization.dto.OAuth2ScopeDto;
import cn.herodotus.engine.oauth2.server.authorization.entity.OAuth2Authority;
import cn.herodotus.engine.oauth2.server.authorization.entity.OAuth2Scope;
import cn.herodotus.engine.oauth2.server.authorization.service.OAuth2ScopeService;
import cn.herodotus.engine.rest.core.controller.BaseWriteableRestController;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/authorize/scope"})
@Tags(value={@Tag(name="OAuth2 \u8ba4\u8bc1\u670d\u52a1\u63a5\u53e3"), @Tag(name="OAuth2 \u6743\u9650\u8303\u56f4\u7ba1\u7406\u63a5\u53e3")})
public class OAuth2ScopeController
extends BaseWriteableRestController<OAuth2Scope, String> {
    private final OAuth2ScopeService scopeService;

    @Autowired
    public OAuth2ScopeController(OAuth2ScopeService scopeService) {
        this.scopeService = scopeService;
    }

    public WriteableService<OAuth2Scope, String> getWriteableService() {
        return this.scopeService;
    }

    @Operation(summary="\u7ed9\u5e94\u7528\u5206\u914dScope", description="\u7ed9\u5e94\u7528\u5206\u914dScope", responses={@ApiResponse(description="\u67e5\u8be2\u5230\u7684\u89d2\u8272", content={@Content(mediaType="application/json", schema=@Schema(implementation=OAuth2ScopeDto.class))})})
    @Parameters(value={@Parameter(name="scope", required=true, description="\u8303\u56f4\u8bf7\u6c42\u53c2\u6570")})
    @PutMapping
    public Result<OAuth2Scope> authorize(@RequestBody OAuth2ScopeDto scope) {
        Set<OAuth2Authority> authorities = new HashSet<OAuth2Authority>();
        if (CollectionUtils.isNotEmpty(scope.getAuthorities())) {
            authorities = scope.getAuthorities().stream().map(this::toEntity).collect(Collectors.toSet());
        }
        OAuth2Scope result = this.scopeService.authorize(scope.getScopeId(), authorities);
        return this.result((Entity)result);
    }

    private OAuth2Authority toEntity(OAuth2AuthorityDto dto) {
        OAuth2Authority entity = new OAuth2Authority();
        entity.setAuthorityId(dto.getAuthorityId());
        entity.setAuthorityCode(dto.getAuthorityCode());
        entity.setServiceId(dto.getServiceId());
        entity.setRequestMethod(dto.getRequestMethod());
        entity.setUrl(dto.getUrl());
        return entity;
    }
}

