/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.server.authorization.entity;

import cn.herodotus.engine.data.core.entity.BaseSysEntity;
import com.google.common.base.MoreObjects;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name="oauth2_authority", indexes={@Index(name="oauth2_authority_id_idx", columnList="authority_id")})
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="data:upms:oauth2:authority")
public class OAuth2Authority
extends BaseSysEntity {
    @Id
    @GeneratedValue(generator="oauth2-authority-uuid")
    @GenericGenerator(name="oauth2-authority-uuid", strategy="cn.herodotus.engine.oauth2.server.authorization.generator.OAuth2AuthorityUUIDGenerator")
    @Column(name="authority_id", length=64)
    private String authorityId;
    @Column(name="authority_code", length=128)
    private String authorityCode;
    @Column(name="service_id", length=128)
    private String serviceId;
    @Column(name="request_method", length=20)
    private String requestMethod;
    @Column(name="url", length=2048)
    private String url;

    public String getAuthorityId() {
        return this.authorityId;
    }

    public void setAuthorityId(String authorityId) {
        this.authorityId = authorityId;
    }

    public String getAuthorityCode() {
        return this.authorityCode;
    }

    public void setAuthorityCode(String authorityCode) {
        this.authorityCode = authorityCode;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public String getRequestMethod() {
        return this.requestMethod;
    }

    public void setRequestMethod(String requestMethod) {
        this.requestMethod = requestMethod;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("authorityId", (Object)this.authorityId).add("authorityCode", (Object)this.authorityCode).add("serviceId", (Object)this.serviceId).add("requestMethod", (Object)this.requestMethod).add("url", (Object)this.url).toString();
    }
}

