/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.server.authorization.processor;

import cn.herodotus.engine.oauth2.core.definition.domain.HerodotusGrantedAuthority;
import cn.herodotus.engine.oauth2.core.definition.service.EnhanceClientDetailsService;
import cn.herodotus.engine.oauth2.server.authorization.entity.OAuth2Application;
import cn.herodotus.engine.oauth2.server.authorization.entity.OAuth2Authority;
import cn.herodotus.engine.oauth2.server.authorization.entity.OAuth2Scope;
import cn.herodotus.engine.oauth2.server.authorization.service.OAuth2ApplicationService;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;

public class HerodotusClientDetailsService
implements EnhanceClientDetailsService {
    private final OAuth2ApplicationService applicationService;

    public HerodotusClientDetailsService(OAuth2ApplicationService applicationService) {
        this.applicationService = applicationService;
    }

    public Set<HerodotusGrantedAuthority> findAuthoritiesById(String clientId) {
        OAuth2Application application = this.applicationService.findByClientId(clientId);
        if (ObjectUtils.isNotEmpty((Object)((Object)application))) {
            Set<OAuth2Scope> scopes = application.getScopes();
            HashSet<HerodotusGrantedAuthority> result = new HashSet<HerodotusGrantedAuthority>();
            if (CollectionUtils.isNotEmpty(scopes)) {
                for (OAuth2Scope scope : scopes) {
                    Set<OAuth2Authority> authorities = scope.getAuthorities();
                    if (!CollectionUtils.isNotEmpty(authorities)) continue;
                    Set grantedAuthorities = authorities.stream().map(item -> new HerodotusGrantedAuthority(item.getAuthorityCode())).collect(Collectors.toSet());
                    result.addAll(grantedAuthorities);
                }
            }
            return result;
        }
        return new HashSet<HerodotusGrantedAuthority>();
    }
}

