/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.server.authorization.processor;

import cn.herodotus.engine.assistant.core.domain.AccessPrincipal;
import cn.herodotus.engine.oauth2.core.definition.domain.HerodotusUser;
import cn.herodotus.engine.oauth2.core.definition.service.EnhanceUserDetailsService;
import cn.herodotus.engine.oauth2.core.definition.strategy.StrategyUserDetailsService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class HerodotusUserDetailsService
implements EnhanceUserDetailsService {
    private static final Logger log = LoggerFactory.getLogger(HerodotusUserDetailsService.class);
    private final StrategyUserDetailsService strategyUserDetailsService;

    public HerodotusUserDetailsService(StrategyUserDetailsService strategyUserDetailsService) {
        this.strategyUserDetailsService = strategyUserDetailsService;
    }

    public HerodotusUser loadUserByUsername(String username) throws UsernameNotFoundException {
        HerodotusUser HerodotusUser2 = this.strategyUserDetailsService.findUserDetailsByUsername(username);
        log.debug("[Herodotus] |- UserDetailsService loaded user : [{}]", (Object)username);
        return HerodotusUser2;
    }

    public UserDetails loadUserBySocial(String source, AccessPrincipal accessPrincipal) throws UsernameNotFoundException {
        HerodotusUser HerodotusUser2 = this.strategyUserDetailsService.findUserDetailsBySocial(StringUtils.toRootUpperCase((String)source), accessPrincipal);
        log.debug("[Herodotus] |- UserDetailsService loaded social user : [{}]", (Object)HerodotusUser2.getUsername());
        return HerodotusUser2;
    }
}

