/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.server.authorization.service;

import cn.herodotus.engine.assistant.core.domain.SecretKey;
import cn.herodotus.engine.protect.web.crypto.processor.HttpCryptoProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InterfaceSecurityService {
    private static final Logger log = LoggerFactory.getLogger(InterfaceSecurityService.class);
    private static final String PKCS1_BEGIN = "-----BEGIN RSA PUBLIC KEY-----";
    private static final String PKCS1_END = "-----END RSA PUBLIC KEY-----";
    private static final String PKCS8_BEGIN = "-----BEGIN PUBLIC KEY-----";
    private static final String PKCS8_END = "-----END PUBLIC KEY-----";
    private final HttpCryptoProcessor httpCryptoProcessor;

    @Autowired
    public InterfaceSecurityService(HttpCryptoProcessor httpCryptoProcessor) {
        this.httpCryptoProcessor = httpCryptoProcessor;
    }

    public SecretKey createSecretKey(String clientId, String clientSecret, String sessionId) {
        return this.httpCryptoProcessor.createSecretKey(sessionId, Integer.valueOf(60));
    }

    public String exchange(String sessionId, String confidentialBase64) {
        return this.httpCryptoProcessor.exchange(sessionId, confidentialBase64);
    }
}

