/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.server.authorization.controller;

import cn.herodotus.engine.assistant.core.domain.Result;
import cn.herodotus.engine.oauth2.core.definition.domain.Authority;
import cn.herodotus.engine.oauth2.core.definition.strategy.StrategyAuthorityDetailsService;
import cn.herodotus.engine.oauth2.server.authorization.entity.OAuth2Authority;
import cn.herodotus.engine.rest.core.controller.Controller;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/authorize/authority"})
@Tags(value={@Tag(name="OAuth2 \u8ba4\u8bc1\u670d\u52a1\u63a5\u53e3"), @Tag(name="OAuth2 \u6743\u9650\u8bfb\u53d6\u63a5\u53e3")})
public class OAuth2AuthorityController
implements Controller {
    private final StrategyAuthorityDetailsService strategyAuthorityDetailsService;

    @Autowired
    public OAuth2AuthorityController(StrategyAuthorityDetailsService strategyAuthorityDetailsService) {
        this.strategyAuthorityDetailsService = strategyAuthorityDetailsService;
    }

    @Operation(summary="\u67e5\u8be2\u6240\u6709\u6743\u9650\u6570\u636e", description="\u67e5\u8be2\u6240\u6709\u6743\u9650\u6570\u636e\u7528\u4e8e\u7ed9Scope\u5206\u914d\u6743\u9650", responses={@ApiResponse(description="\u6743\u9650\u5217\u8868", content={@Content(mediaType="application/json", schema=@Schema(implementation=OAuth2Authority.class))})})
    @GetMapping(value={"/condition"})
    public Result<List<OAuth2Authority>> findAll() {
        List authorities = this.strategyAuthorityDetailsService.findAll();
        if (CollectionUtils.isNotEmpty((Collection)authorities)) {
            List<OAuth2Authority> result = this.toEntities(authorities);
            return this.result(result);
        }
        return Result.empty((String)"\u672a\u67e5\u8be2\u5230\u6570\u636e");
    }

    private List<OAuth2Authority> toEntities(List<Authority> authorities) {
        return authorities.stream().map(this::toEntity).collect(Collectors.toList());
    }

    private OAuth2Authority toEntity(Authority object) {
        OAuth2Authority authority = new OAuth2Authority();
        authority.setAuthorityId(object.getAuthorityId());
        authority.setAuthorityCode(object.getAuthorityCode());
        authority.setServiceId(object.getServiceId());
        authority.setRequestMethod(object.getRequestMethod());
        authority.setUrl(object.getUrl());
        return authority;
    }
}

