/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.server.authorization.entity;

import cn.herodotus.engine.data.core.entity.BaseSysEntity;
import cn.herodotus.engine.oauth2.server.authorization.entity.OAuth2Authority;
import com.google.common.base.MoreObjects;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name="oauth2_scope", uniqueConstraints={@UniqueConstraint(columnNames={"scope_code"})}, indexes={@Index(name="oauth2_scope_id_idx", columnList="scope_id"), @Index(name="oauth2_scope_code_idx", columnList="scope_code")})
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="data:upms:oauth2:scope")
public class OAuth2Scope
extends BaseSysEntity {
    @Id
    @GeneratedValue(generator="system-uuid")
    @GenericGenerator(name="system-uuid", strategy="uuid2")
    @Column(name="scope_id", length=64)
    private String scopeId;
    @Column(name="scope_code", length=128, unique=true)
    private String scopeCode;
    @Column(name="scope_name", length=128)
    private String scopeName;
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="data:upms:oauth2:authority")
    @ManyToMany(cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REFRESH}, fetch=FetchType.EAGER)
    @Fetch(value=FetchMode.SUBSELECT)
    @JoinTable(name="oauth2_scope_authority", joinColumns={@JoinColumn(name="scope_id")}, inverseJoinColumns={@JoinColumn(name="authority_id")}, uniqueConstraints={@UniqueConstraint(columnNames={"scope_id", "authority_id"})}, indexes={@Index(name="oauth2_scope_authority_sid_idx", columnList="scope_id"), @Index(name="oauth2_scope_authority_aid_idx", columnList="authority_id")})
    private Set<OAuth2Authority> authorities = new HashSet<OAuth2Authority>();

    public String getScopeId() {
        return this.scopeId;
    }

    public void setScopeId(String scopeId) {
        this.scopeId = scopeId;
    }

    public String getScopeCode() {
        return this.scopeCode;
    }

    public void setScopeCode(String scopeCode) {
        this.scopeCode = scopeCode;
    }

    public String getScopeName() {
        return this.scopeName;
    }

    public void setScopeName(String scopeName) {
        this.scopeName = scopeName;
    }

    public Set<OAuth2Authority> getAuthorities() {
        return this.authorities;
    }

    public void setAuthorities(Set<OAuth2Authority> authorities) {
        this.authorities = authorities;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        OAuth2Scope that = (OAuth2Scope)((Object)o);
        return new EqualsBuilder().append((Object)this.getScopeId(), (Object)that.getScopeId()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.getScopeId()).toHashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("scopeId", (Object)this.scopeId).add("scopeCode", (Object)this.scopeCode).add("scopeName", (Object)this.scopeName).toString();
    }
}

